/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.image;

import java.util.AbstractList;
import java.util.List;

class SubList<E>
extends AbstractList<E> {
    private List<E> parent;
    private int startIndex;
    private int size;

    SubList(List<E> parent, int startIndex, int size) {
        this.parent = parent;
        this.startIndex = startIndex;
        this.size = size;
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.parent.get(index + this.startIndex);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void add(int index, E element) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.parent.add(index + this.startIndex, element);
        ++this.size;
    }

    @Override
    public E remove(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        E element = this.parent.remove(index + this.startIndex);
        --this.size;
        return element;
    }
}

