/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.image2pdf;

import com.pdftools.geometry.units.Margin;
import com.pdftools.geometry.units.Size;
import com.pdftools.image2pdf.ImageMapping;

public class Auto
extends ImageMapping {
    protected Auto(long handle) {
        super(handle);
    }

    public static Auto createDynamicObject(long handle) {
        return new Auto(handle);
    }

    public Auto() {
        this(Auto.newHelper());
    }

    private static long newHelper() {
        long handle = Auto.newNative();
        if (handle == 0L) {
            switch (Auto.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Auto.throwLastRuntimeException();
        }
        return handle;
    }

    public Size getMaxPageSize() {
        Size retVal = this.getMaxPageSizeNative(this.getHandle());
        if (retVal == null) {
            switch (Auto.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Auto.throwLastRuntimeException();
        }
        return retVal;
    }

    public void setMaxPageSize(Size value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setMaxPageSizeNative(this.getHandle(), value.getWidthValue(), value.getHeightValue());
        if (!retVal) {
            switch (Auto.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Auto.getLastErrorMessage());
                }
            }
            Auto.throwLastRuntimeException();
        }
    }

    public Margin getDefaultPageMargin() {
        Margin retVal = this.getDefaultPageMarginNative(this.getHandle());
        if (retVal == null) {
            switch (Auto.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Auto.throwLastRuntimeException();
        }
        return retVal;
    }

    public void setDefaultPageMargin(Margin value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setDefaultPageMarginNative(this.getHandle(), value.getLeftValue(), value.getBottomValue(), value.getRightValue(), value.getTopValue());
        if (!retVal) {
            switch (Auto.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Auto.getLastErrorMessage());
                }
            }
            Auto.throwLastRuntimeException();
        }
    }

    private static native long newNative();

    private native Size getMaxPageSizeNative(long var1);

    private native boolean setMaxPageSizeNative(long var1, double var3, double var5);

    private native Margin getDefaultPageMarginNative(long var1);

    private native boolean setDefaultPageMarginNative(long var1, double var3, double var5, double var7, double var9);
}

