/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.image2pdf;

import com.pdftools.CorruptException;
import com.pdftools.GenericException;
import com.pdftools.LicenseException;
import com.pdftools.ProcessingException;
import com.pdftools.image.Document;
import com.pdftools.image.DocumentList;
import com.pdftools.image2pdf.profiles.Profile;
import com.pdftools.internal.NativeObject;
import com.pdftools.pdf.OutputOptions;
import com.pdftools.sys.Stream;
import java.io.IOException;

public class Converter
extends NativeObject {
    protected Converter(long handle) {
        super(handle);
    }

    public static Converter createDynamicObject(long handle) {
        return new Converter(handle);
    }

    public Converter() {
        this(Converter.newHelper());
    }

    private static long newHelper() {
        long handle = Converter.newNative();
        if (handle == 0L) {
            switch (Converter.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Converter.throwLastRuntimeException();
        }
        return handle;
    }

    public com.pdftools.pdf.Document convert(Document image, Stream outStream, Profile profile) throws IOException, GenericException, LicenseException, CorruptException, ProcessingException {
        if (image == null) {
            throw new IllegalArgumentException("Argument 'image' must not be null.", new NullPointerException("'image'"));
        }
        if (outStream == null) {
            throw new IllegalArgumentException("Argument 'outStream' must not be null.", new NullPointerException("'outStream'"));
        }
        if (profile == null) {
            throw new IllegalArgumentException("Argument 'profile' must not be null.", new NullPointerException("'profile'"));
        }
        return this.convert(image, outStream, profile, null);
    }

    public com.pdftools.pdf.Document convert(Document image, Stream outStream, Profile profile, OutputOptions outOptions) throws IOException, GenericException, LicenseException, CorruptException, ProcessingException {
        if (image == null) {
            throw new IllegalArgumentException("Argument 'image' must not be null.", new NullPointerException("'image'"));
        }
        if (outStream == null) {
            throw new IllegalArgumentException("Argument 'outStream' must not be null.", new NullPointerException("'outStream'"));
        }
        if (profile == null) {
            throw new IllegalArgumentException("Argument 'profile' must not be null.", new NullPointerException("'profile'"));
        }
        long retHandle = this.convertNative(this.getHandle(), Converter.getHandle(image), image, outStream, Converter.getHandle(profile), profile, Converter.getHandle(outOptions), outOptions);
        if (retHandle == 0L) {
            switch (Converter.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Converter.getLastErrorMessage());
                }
                case 4: {
                    throw new IOException(Converter.getLastErrorMessage());
                }
                case 10: {
                    throw new GenericException(Converter.getLastErrorMessage());
                }
                case 12: {
                    throw new LicenseException(Converter.getLastErrorMessage());
                }
                case 16: {
                    throw new CorruptException(Converter.getLastErrorMessage());
                }
                case 21: {
                    throw new ProcessingException(Converter.getLastErrorMessage());
                }
            }
            Converter.throwLastRuntimeException();
        }
        return com.pdftools.pdf.Document.createDynamicObject(retHandle);
    }

    public com.pdftools.pdf.Document convertMultiple(DocumentList images, Stream outStream, Profile profile) throws IOException, GenericException, LicenseException, CorruptException, ProcessingException {
        if (images == null) {
            throw new IllegalArgumentException("Argument 'images' must not be null.", new NullPointerException("'images'"));
        }
        if (outStream == null) {
            throw new IllegalArgumentException("Argument 'outStream' must not be null.", new NullPointerException("'outStream'"));
        }
        if (profile == null) {
            throw new IllegalArgumentException("Argument 'profile' must not be null.", new NullPointerException("'profile'"));
        }
        return this.convertMultiple(images, outStream, profile, null);
    }

    public com.pdftools.pdf.Document convertMultiple(DocumentList images, Stream outStream, Profile profile, OutputOptions outOptions) throws IOException, GenericException, LicenseException, CorruptException, ProcessingException {
        if (images == null) {
            throw new IllegalArgumentException("Argument 'images' must not be null.", new NullPointerException("'images'"));
        }
        if (outStream == null) {
            throw new IllegalArgumentException("Argument 'outStream' must not be null.", new NullPointerException("'outStream'"));
        }
        if (profile == null) {
            throw new IllegalArgumentException("Argument 'profile' must not be null.", new NullPointerException("'profile'"));
        }
        long retHandle = this.convertMultipleNative(this.getHandle(), Converter.getHandle(images), images, outStream, Converter.getHandle(profile), profile, Converter.getHandle(outOptions), outOptions);
        if (retHandle == 0L) {
            switch (Converter.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Converter.getLastErrorMessage());
                }
                case 4: {
                    throw new IOException(Converter.getLastErrorMessage());
                }
                case 10: {
                    throw new GenericException(Converter.getLastErrorMessage());
                }
                case 12: {
                    throw new LicenseException(Converter.getLastErrorMessage());
                }
                case 16: {
                    throw new CorruptException(Converter.getLastErrorMessage());
                }
                case 21: {
                    throw new ProcessingException(Converter.getLastErrorMessage());
                }
            }
            Converter.throwLastRuntimeException();
        }
        return com.pdftools.pdf.Document.createDynamicObject(retHandle);
    }

    private static native long newNative();

    private native long convertNative(long var1, long var3, Document var5, Stream var6, long var7, Profile var9, long var10, OutputOptions var12);

    private native long convertMultipleNative(long var1, long var3, DocumentList var5, Stream var6, long var7, Profile var9, long var10, OutputOptions var12);
}

