/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.image2pdf;

import com.pdftools.geometry.units.Margin;
import com.pdftools.geometry.units.Size;
import com.pdftools.image2pdf.ImageMapping;

public class ShrinkToFit
extends ImageMapping {
    protected ShrinkToFit(long handle) {
        super(handle);
    }

    public static ShrinkToFit createDynamicObject(long handle) {
        return new ShrinkToFit(handle);
    }

    public ShrinkToFit() {
        this(ShrinkToFit.newHelper());
    }

    private static long newHelper() {
        long handle = ShrinkToFit.newNative();
        if (handle == 0L) {
            switch (ShrinkToFit.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            ShrinkToFit.throwLastRuntimeException();
        }
        return handle;
    }

    public Size getPageSize() {
        Size retVal = this.getPageSizeNative(this.getHandle());
        if (retVal == null) {
            switch (ShrinkToFit.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            ShrinkToFit.throwLastRuntimeException();
        }
        return retVal;
    }

    public void setPageSize(Size value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setPageSizeNative(this.getHandle(), value.getWidthValue(), value.getHeightValue());
        if (!retVal) {
            switch (ShrinkToFit.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(ShrinkToFit.getLastErrorMessage());
                }
            }
            ShrinkToFit.throwLastRuntimeException();
        }
    }

    public Margin getPageMargin() {
        Margin retVal = this.getPageMarginNative(this.getHandle());
        if (retVal == null) {
            switch (ShrinkToFit.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            ShrinkToFit.throwLastRuntimeException();
        }
        return retVal;
    }

    public void setPageMargin(Margin value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setPageMarginNative(this.getHandle(), value.getLeftValue(), value.getBottomValue(), value.getRightValue(), value.getTopValue());
        if (!retVal) {
            switch (ShrinkToFit.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(ShrinkToFit.getLastErrorMessage());
                }
            }
            ShrinkToFit.throwLastRuntimeException();
        }
    }

    public boolean getForceFit() {
        boolean retVal = this.getForceFitNative(this.getHandle());
        if (!retVal) {
            switch (ShrinkToFit.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    ShrinkToFit.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setForceFit(boolean value) {
        boolean retVal = this.setForceFitNative(this.getHandle(), value);
        if (!retVal) {
            switch (ShrinkToFit.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            ShrinkToFit.throwLastRuntimeException();
        }
    }

    private static native long newNative();

    private native Size getPageSizeNative(long var1);

    private native boolean setPageSizeNative(long var1, double var3, double var5);

    private native Margin getPageMarginNative(long var1);

    private native boolean setPageMarginNative(long var1, double var3, double var5, double var7, double var9);

    private native boolean getForceFitNative(long var1);

    private native boolean setForceFitNative(long var1, boolean var3);
}

