/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.image2pdf;

import com.pdftools.geometry.units.Margin;
import com.pdftools.geometry.units.Size;
import com.pdftools.image2pdf.ImageMapping;

public class ShrinkToPage
extends ImageMapping {
    protected ShrinkToPage(long handle) {
        super(handle);
    }

    public static ShrinkToPage createDynamicObject(long handle) {
        return new ShrinkToPage(handle);
    }

    public ShrinkToPage() {
        this(ShrinkToPage.newHelper());
    }

    private static long newHelper() {
        long handle = ShrinkToPage.newNative();
        if (handle == 0L) {
            switch (ShrinkToPage.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            ShrinkToPage.throwLastRuntimeException();
        }
        return handle;
    }

    public Size getPageSize() {
        Size retVal = this.getPageSizeNative(this.getHandle());
        if (retVal == null) {
            switch (ShrinkToPage.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            ShrinkToPage.throwLastRuntimeException();
        }
        return retVal;
    }

    public void setPageSize(Size value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setPageSizeNative(this.getHandle(), value.getWidthValue(), value.getHeightValue());
        if (!retVal) {
            switch (ShrinkToPage.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(ShrinkToPage.getLastErrorMessage());
                }
            }
            ShrinkToPage.throwLastRuntimeException();
        }
    }

    public Margin getPageMargin() {
        Margin retVal = this.getPageMarginNative(this.getHandle());
        if (retVal == null) {
            switch (ShrinkToPage.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            ShrinkToPage.throwLastRuntimeException();
        }
        return retVal;
    }

    public void setPageMargin(Margin value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setPageMarginNative(this.getHandle(), value.getLeftValue(), value.getBottomValue(), value.getRightValue(), value.getTopValue());
        if (!retVal) {
            switch (ShrinkToPage.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(ShrinkToPage.getLastErrorMessage());
                }
            }
            ShrinkToPage.throwLastRuntimeException();
        }
    }

    private static native long newNative();

    private native Size getPageSizeNative(long var1);

    private native boolean setPageSizeNative(long var1, double var3, double var5);

    private native Margin getPageMarginNative(long var1);

    private native boolean setPageMarginNative(long var1, double var3, double var5, double var7, double var9);
}

