/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.image2pdf.profiles;

import com.pdftools.StringList;
import com.pdftools.image2pdf.profiles.Profile;
import com.pdftools.pdf.Conformance;

public class Archive
extends Profile {
    protected Archive(long handle) {
        super(handle);
    }

    public static Archive createDynamicObject(long handle) {
        return new Archive(handle);
    }

    public Archive() {
        this(Archive.newHelper());
    }

    private static long newHelper() {
        long handle = Archive.newNative();
        if (handle == 0L) {
            switch (Archive.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Archive.throwLastRuntimeException();
        }
        return handle;
    }

    public Conformance getConformance() {
        int retVal = this.getConformanceNative(this.getHandle());
        if (retVal == 0) {
            switch (Archive.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Archive.throwLastRuntimeException();
                }
            }
        }
        return new Conformance(retVal);
    }

    public void setConformance(Conformance value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setConformanceNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (Archive.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Archive.getLastErrorMessage());
                }
            }
            Archive.throwLastRuntimeException();
        }
    }

    public StringList getAlternateText() {
        long retHandle = this.getAlternateTextNative(this.getHandle());
        if (retHandle == 0L) {
            switch (Archive.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Archive.throwLastRuntimeException();
        }
        return StringList.createDynamicObject(retHandle);
    }

    public void setAlternateText(StringList value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setAlternateTextNative(this.getHandle(), Archive.getHandle(value), value);
        if (!retVal) {
            switch (Archive.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Archive.throwLastRuntimeException();
        }
    }

    public String getLanguage() {
        String retVal = this.getLanguageNative(this.getHandle());
        if (retVal == null) {
            switch (Archive.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Archive.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setLanguage(String value) {
        boolean retVal = this.setLanguageNative(this.getHandle(), value);
        if (!retVal) {
            switch (Archive.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Archive.throwLastRuntimeException();
        }
    }

    private static native long newNative();

    private native int getConformanceNative(long var1);

    private native boolean setConformanceNative(long var1, int var3);

    private native long getAlternateTextNative(long var1);

    private native boolean setAlternateTextNative(long var1, long var3, StringList var5);

    private native String getLanguageNative(long var1);

    private native boolean setLanguageNative(long var1, String var3);
}

