/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.internal;

import com.pdftools.ConformanceException;
import com.pdftools.CorruptException;
import com.pdftools.ExistsException;
import com.pdftools.GenericException;
import com.pdftools.HttpException;
import com.pdftools.LicenseException;
import com.pdftools.NotFoundException;
import com.pdftools.PasswordException;
import com.pdftools.PdfToolsException;
import com.pdftools.PermissionException;
import com.pdftools.ProcessingException;
import com.pdftools.RetryException;
import com.pdftools.UnknownFormatException;
import com.pdftools.UnsupportedFeatureException;
import com.pdftools.internal.Flag;
import com.pdftools.internal.NativeObject;
import java.io.IOException;
import java.util.EnumSet;

public abstract class NativeBase {
    protected NativeBase() {
    }

    protected static void throwLastRuntimeException() {
        NativeBase.throwLastRuntimeException(true);
    }

    protected static void throwLastRuntimeException(boolean allowSuccess) {
        switch (NativeBase.getLastErrorCode()) {
            case 1: {
                throw new UnsupportedOperationException(NativeBase.getLastErrorMessage());
            }
            case 2: {
                throw new IllegalStateException(NativeBase.getLastErrorMessage());
            }
            case 3: {
                throw new IllegalArgumentException(NativeBase.getLastErrorMessage());
            }
            case 0: {
                if (allowSuccess) {
                    return;
                }
            }
            case 10: {
                throw new RuntimeException(new GenericException(NativeBase.getLastErrorMessage()));
            }
            case 12: {
                throw new RuntimeException(new LicenseException(NativeBase.getLastErrorMessage()));
            }
            case 15: {
                throw new RuntimeException(new UnknownFormatException(NativeBase.getLastErrorMessage()));
            }
            case 16: {
                throw new RuntimeException(new CorruptException(NativeBase.getLastErrorMessage()));
            }
            case 17: {
                throw new RuntimeException(new PasswordException(NativeBase.getLastErrorMessage()));
            }
            case 18: {
                throw new RuntimeException(new ConformanceException(NativeBase.getLastErrorMessage()));
            }
            case 19: {
                throw new RuntimeException(new UnsupportedFeatureException(NativeBase.getLastErrorMessage()));
            }
            case 21: {
                throw new RuntimeException(new ProcessingException(NativeBase.getLastErrorMessage()));
            }
            case 22: {
                throw new RuntimeException(new ExistsException(NativeBase.getLastErrorMessage()));
            }
            case 23: {
                throw new RuntimeException(new PermissionException(NativeBase.getLastErrorMessage()));
            }
            case 24: {
                throw new RuntimeException(new HttpException(NativeBase.getLastErrorMessage()));
            }
            case 25: {
                throw new RuntimeException(new RetryException(NativeBase.getLastErrorMessage()));
            }
            case 5: {
                throw new RuntimeException(new NotFoundException(NativeBase.getLastErrorMessage()));
            }
            case 4: {
                throw new RuntimeException(new IOException(NativeBase.getLastErrorMessage()));
            }
        }
        throw new RuntimeException(NativeBase.getLastErrorMessage());
    }

    protected static void throwLastError(boolean allowSuccess) throws PdfToolsException, IOException {
        switch (NativeBase.getLastErrorCode()) {
            case 1: {
                throw new UnsupportedOperationException(NativeBase.getLastErrorMessage());
            }
            case 2: {
                throw new IllegalStateException(NativeBase.getLastErrorMessage());
            }
            case 3: {
                throw new IllegalArgumentException(NativeBase.getLastErrorMessage());
            }
            case 0: {
                if (allowSuccess) {
                    return;
                }
                throw new RuntimeException("An unexpected error occurred");
            }
            case 10: {
                throw new GenericException(NativeBase.getLastErrorMessage());
            }
            case 12: {
                throw new LicenseException(NativeBase.getLastErrorMessage());
            }
            case 15: {
                throw new UnknownFormatException(NativeBase.getLastErrorMessage());
            }
            case 16: {
                throw new CorruptException(NativeBase.getLastErrorMessage());
            }
            case 17: {
                throw new PasswordException(NativeBase.getLastErrorMessage());
            }
            case 18: {
                throw new ConformanceException(NativeBase.getLastErrorMessage());
            }
            case 19: {
                throw new UnsupportedFeatureException(NativeBase.getLastErrorMessage());
            }
            case 21: {
                throw new ProcessingException(NativeBase.getLastErrorMessage());
            }
            case 22: {
                throw new ExistsException(NativeBase.getLastErrorMessage());
            }
            case 23: {
                throw new PermissionException(NativeBase.getLastErrorMessage());
            }
            case 24: {
                throw new HttpException(NativeBase.getLastErrorMessage());
            }
            case 25: {
                throw new RetryException(NativeBase.getLastErrorMessage());
            }
            case 5: {
                throw new NotFoundException(NativeBase.getLastErrorMessage());
            }
            case 4: {
                throw new IOException(NativeBase.getLastErrorMessage());
            }
        }
    }

    protected static Exception createError(int errorCode, String errorMessage, boolean allowSuccess) {
        switch (errorCode) {
            case 1: {
                return new UnsupportedOperationException(errorMessage);
            }
            case 2: {
                return new IllegalStateException(errorMessage);
            }
            case 3: {
                return new IllegalArgumentException(errorMessage);
            }
            case 0: {
                if (allowSuccess) {
                    return null;
                }
                return new RuntimeException("An unexpected error occurred");
            }
            case 10: {
                return new GenericException(errorMessage);
            }
            case 12: {
                return new LicenseException(errorMessage);
            }
            case 15: {
                return new UnknownFormatException(errorMessage);
            }
            case 16: {
                return new CorruptException(errorMessage);
            }
            case 17: {
                return new PasswordException(errorMessage);
            }
            case 18: {
                return new ConformanceException(errorMessage);
            }
            case 19: {
                return new UnsupportedFeatureException(errorMessage);
            }
            case 21: {
                return new ProcessingException(errorMessage);
            }
            case 22: {
                return new ExistsException(errorMessage);
            }
            case 23: {
                return new PermissionException(errorMessage);
            }
            case 24: {
                return new HttpException(errorMessage);
            }
            case 25: {
                return new RetryException(errorMessage);
            }
            case 5: {
                return new NotFoundException(errorMessage);
            }
            case 4: {
                return new IOException(errorMessage);
            }
        }
        return null;
    }

    protected static void throwLastError() throws PdfToolsException, IOException {
        NativeBase.throwLastError(true);
    }

    protected static <E extends Enum<E>> int getFlags(EnumSet<E> eset) {
        int flags = 0;
        for (Enum e : eset) {
            flags |= ((Flag)((Object)e)).getFlag();
        }
        return flags;
    }

    protected static <E extends Enum<E>> EnumSet<E> getEnumSet(int flags, Class<E> clazz) {
        EnumSet<Enum> eset = EnumSet.noneOf(clazz);
        for (Enum x : (Enum[])clazz.getEnumConstants()) {
            if ((((Flag)((Object)x)).getFlag() & flags) == 0) continue;
            eset.add(x);
        }
        return eset;
    }

    protected static long getHandle(NativeObject object) {
        if (object == null) {
            return 0L;
        }
        return object.getHandle();
    }

    protected static void addRef(NativeObject object) {
        if (object == null) {
            return;
        }
        object.addRef();
    }

    protected long getHandle() throws Exception {
        throw new Exception("Not implemented.");
    }

    private static void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                NativeBase.uninitialize();
            }
        });
    }

    protected static native int getLastErrorCode();

    protected static native String getLastErrorMessage();

    protected static native void setLastErrorNative(int var0, String var1);

    private static native void initialize();

    private static native void uninitialize();

    static {
        try {
            NativeBase.initialize();
            NativeBase.addShutdownHook();
        }
        catch (UnsatisfiedLinkError ue) {
            System.loadLibrary("PdfToolsSdk");
            NativeBase.initialize();
            NativeBase.addShutdownHook();
        }
    }
}

