/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.internal;

import com.pdftools.internal.NativeBase;
import com.pdftools.sys.Stream;
import java.io.IOException;

public class NativeStream
implements Stream {
    private long handle;
    private long readHandle;
    private long getLengthHandle;
    private long seekHandle;
    private long tellHandle;
    private long writeHandle;
    private long releaseHandle;

    @Override
    public long getLength() throws IOException {
        if (this.handle == 0L) {
            throw new IllegalStateException();
        }
        long retVal = NativeStream.getLengthNative(this.handle, this.getLengthHandle);
        if (retVal == -1L) {
            this.throwLastError();
        }
        return retVal;
    }

    @Override
    public boolean seek(long position) throws IOException {
        if (this.handle == 0L) {
            throw new IllegalStateException();
        }
        if (!NativeStream.seekNative(this.handle, this.seekHandle, position)) {
            this.throwLastError();
        }
        return true;
    }

    @Override
    public long tell() throws IOException {
        if (this.handle == 0L) {
            throw new IllegalStateException();
        }
        long retVal = NativeStream.tellNative(this.handle, this.tellHandle);
        if (retVal == -1L) {
            this.throwLastError();
        }
        return retVal;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.handle == 0L) {
            throw new IllegalStateException();
        }
        int retVal = NativeStream.readNative(this.handle, this.readHandle, buffer, offset, length);
        if (retVal == -1) {
            this.throwLastError();
        }
        return retVal;
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        if (this.handle == 0L) {
            throw new IllegalStateException();
        }
        long retVal = NativeStream.writeNative(this.handle, this.writeHandle, buffer, offset, length);
        if (retVal == -1L) {
            this.throwLastError();
        }
    }

    public void copy(Stream stream) throws IOException {
        int read;
        if (this.handle == 0L) {
            throw new IllegalStateException();
        }
        byte[] buffer = new byte[8192];
        while ((read = stream.read(buffer, 0, 8192)) >= 0) {
            this.write(buffer, 0, read);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.handle == 0L) {
            throw new IllegalStateException();
        }
        try {
            NativeStream.closeNative(this.handle, this.releaseHandle);
        }
        finally {
            this.handle = 0L;
        }
    }

    protected void finalize() throws Throwable {
        try {
            NativeStream.finalize(this.handle);
        }
        finally {
            super.finalize();
        }
    }

    private void throwLastError() throws IOException {
        switch (NativeBase.getLastErrorCode()) {
            case 1: {
                throw new UnsupportedOperationException(NativeBase.getLastErrorMessage());
            }
            case 2: {
                throw new IllegalStateException(NativeBase.getLastErrorMessage());
            }
            case 3: {
                throw new IllegalArgumentException(NativeBase.getLastErrorMessage());
            }
        }
        NativeBase.throwLastRuntimeException(false);
    }

    private static native int readNative(long var0, long var2, byte[] var4, int var5, int var6);

    private static native long getLengthNative(long var0, long var2);

    private static native boolean seekNative(long var0, long var2, long var4);

    private static native long tellNative(long var0, long var2);

    private static native long writeNative(long var0, long var2, byte[] var4, int var5, int var6);

    private static native void closeNative(long var0, long var2);

    private static native void finalize(long var0);
}

