/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.optimization;

import com.pdftools.internal.NativeObject;
import com.pdftools.optimization.CompressionAlgorithmSelection;

public class ImageRecompressionOptions
extends NativeObject {
    protected ImageRecompressionOptions(long handle) {
        super(handle);
    }

    public static ImageRecompressionOptions createDynamicObject(long handle) {
        return new ImageRecompressionOptions(handle);
    }

    public CompressionAlgorithmSelection getAlgorithmSelection() {
        int retVal = this.getAlgorithmSelectionNative(this.getHandle());
        if (retVal == 0) {
            switch (ImageRecompressionOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    ImageRecompressionOptions.throwLastRuntimeException();
                }
            }
        }
        return CompressionAlgorithmSelection.fromValue(retVal);
    }

    public void setAlgorithmSelection(CompressionAlgorithmSelection value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setAlgorithmSelectionNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (ImageRecompressionOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            ImageRecompressionOptions.throwLastRuntimeException();
        }
    }

    public double getCompressionQuality() {
        double retVal = this.getCompressionQualityNative(this.getHandle());
        if (retVal == -1.0) {
            switch (ImageRecompressionOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    ImageRecompressionOptions.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setCompressionQuality(double value) {
        boolean retVal = this.setCompressionQualityNative(this.getHandle(), value);
        if (!retVal) {
            switch (ImageRecompressionOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(ImageRecompressionOptions.getLastErrorMessage());
                }
            }
            ImageRecompressionOptions.throwLastRuntimeException();
        }
    }

    public boolean getReduceColorComplexity() {
        boolean retVal = this.getReduceColorComplexityNative(this.getHandle());
        if (!retVal) {
            switch (ImageRecompressionOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    ImageRecompressionOptions.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setReduceColorComplexity(boolean value) {
        boolean retVal = this.setReduceColorComplexityNative(this.getHandle(), value);
        if (!retVal) {
            switch (ImageRecompressionOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            ImageRecompressionOptions.throwLastRuntimeException();
        }
    }

    private native int getAlgorithmSelectionNative(long var1);

    private native boolean setAlgorithmSelectionNative(long var1, int var3);

    private native double getCompressionQualityNative(long var1);

    private native boolean setCompressionQualityNative(long var1, double var3);

    private native boolean getReduceColorComplexityNative(long var1);

    private native boolean setReduceColorComplexityNative(long var1, boolean var3);
}

