/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.optimization;

import com.pdftools.GenericException;
import com.pdftools.LicenseException;
import com.pdftools.ProcessingException;
import com.pdftools.internal.NativeObject;
import com.pdftools.optimization.profiles.Profile;
import com.pdftools.pdf.Document;
import com.pdftools.pdf.OutputOptions;
import com.pdftools.sys.Stream;
import java.io.IOException;

public class Optimizer
extends NativeObject {
    protected Optimizer(long handle) {
        super(handle);
    }

    public static Optimizer createDynamicObject(long handle) {
        return new Optimizer(handle);
    }

    public Optimizer() {
        this(Optimizer.newHelper());
    }

    private static long newHelper() {
        long handle = Optimizer.newNative();
        if (handle == 0L) {
            switch (Optimizer.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Optimizer.throwLastRuntimeException();
        }
        return handle;
    }

    public Document optimizeDocument(Document inDoc, Stream outStream, Profile profile) throws IOException, GenericException, LicenseException, ProcessingException {
        if (inDoc == null) {
            throw new IllegalArgumentException("Argument 'inDoc' must not be null.", new NullPointerException("'inDoc'"));
        }
        if (outStream == null) {
            throw new IllegalArgumentException("Argument 'outStream' must not be null.", new NullPointerException("'outStream'"));
        }
        if (profile == null) {
            throw new IllegalArgumentException("Argument 'profile' must not be null.", new NullPointerException("'profile'"));
        }
        return this.optimizeDocument(inDoc, outStream, profile, null);
    }

    public Document optimizeDocument(Document inDoc, Stream outStream, Profile profile, OutputOptions outOptions) throws IOException, GenericException, LicenseException, ProcessingException {
        if (inDoc == null) {
            throw new IllegalArgumentException("Argument 'inDoc' must not be null.", new NullPointerException("'inDoc'"));
        }
        if (outStream == null) {
            throw new IllegalArgumentException("Argument 'outStream' must not be null.", new NullPointerException("'outStream'"));
        }
        if (profile == null) {
            throw new IllegalArgumentException("Argument 'profile' must not be null.", new NullPointerException("'profile'"));
        }
        long retHandle = this.optimizeDocumentNative(this.getHandle(), Optimizer.getHandle(inDoc), inDoc, outStream, Optimizer.getHandle(profile), profile, Optimizer.getHandle(outOptions), outOptions);
        if (retHandle == 0L) {
            switch (Optimizer.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Optimizer.getLastErrorMessage());
                }
                case 4: {
                    throw new IOException(Optimizer.getLastErrorMessage());
                }
                case 10: {
                    throw new GenericException(Optimizer.getLastErrorMessage());
                }
                case 12: {
                    throw new LicenseException(Optimizer.getLastErrorMessage());
                }
                case 21: {
                    throw new ProcessingException(Optimizer.getLastErrorMessage());
                }
            }
            Optimizer.throwLastRuntimeException();
        }
        return Document.createDynamicObject(retHandle);
    }

    private static native long newNative();

    private native long optimizeDocumentNative(long var1, long var3, Document var5, Stream var6, long var7, Profile var9, long var10, OutputOptions var12);
}

