/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.optimization.profiles;

import com.pdftools.optimization.profiles.Profile;

public class Mrc
extends Profile {
    protected Mrc(long handle) {
        super(handle);
    }

    public static Mrc createDynamicObject(long handle) {
        return new Mrc(handle);
    }

    public Mrc() {
        this(Mrc.newHelper());
    }

    private static long newHelper() {
        long handle = Mrc.newNative();
        if (handle == 0L) {
            switch (Mrc.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Mrc.throwLastRuntimeException();
        }
        return handle;
    }

    public double getLayerCompressionQuality() {
        double retVal = this.getLayerCompressionQualityNative(this.getHandle());
        if (retVal == 0.0) {
            switch (Mrc.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Mrc.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setLayerCompressionQuality(double value) {
        boolean retVal = this.setLayerCompressionQualityNative(this.getHandle(), value);
        if (!retVal) {
            switch (Mrc.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Mrc.getLastErrorMessage());
                }
            }
            Mrc.throwLastRuntimeException();
        }
    }

    public Double getLayerResolutionDPI() {
        Double retVal = this.getLayerResolutionDPINative(this.getHandle());
        if (retVal == null) {
            switch (Mrc.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Mrc.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setLayerResolutionDPI(Double value) {
        boolean retVal = this.setLayerResolutionDPINative(this.getHandle(), value);
        if (!retVal) {
            switch (Mrc.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Mrc.getLastErrorMessage());
                }
            }
            Mrc.throwLastRuntimeException();
        }
    }

    public boolean getRecognizePictures() {
        boolean retVal = this.getRecognizePicturesNative(this.getHandle());
        if (!retVal) {
            switch (Mrc.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Mrc.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setRecognizePictures(boolean value) {
        boolean retVal = this.setRecognizePicturesNative(this.getHandle(), value);
        if (!retVal) {
            switch (Mrc.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Mrc.throwLastRuntimeException();
        }
    }

    private static native long newNative();

    private native double getLayerCompressionQualityNative(long var1);

    private native boolean setLayerCompressionQualityNative(long var1, double var3);

    private native Double getLayerResolutionDPINative(long var1);

    private native boolean setLayerResolutionDPINative(long var1, Double var3);

    private native boolean getRecognizePicturesNative(long var1);

    private native boolean setRecognizePicturesNative(long var1, boolean var3);
}

