/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.optimization.profiles;

import com.pdftools.internal.NativeObject;
import com.pdftools.optimization.FontOptions;
import com.pdftools.optimization.ImageRecompressionOptions;
import com.pdftools.optimization.RemovalOptions;
import com.pdftools.optimization.profiles.Archive;
import com.pdftools.optimization.profiles.MinimalFileSize;
import com.pdftools.optimization.profiles.Mrc;
import com.pdftools.optimization.profiles.Print;
import com.pdftools.optimization.profiles.Web;

public abstract class Profile
extends NativeObject {
    protected Profile(long handle) {
        super(handle);
    }

    public static Profile createDynamicObject(long handle) {
        int type = Profile.getType(handle);
        switch (type) {
            case 1: {
                return Web.createDynamicObject(handle);
            }
            case 2: {
                return Print.createDynamicObject(handle);
            }
            case 3: {
                return Archive.createDynamicObject(handle);
            }
            case 4: {
                return MinimalFileSize.createDynamicObject(handle);
            }
            case 5: {
                return Mrc.createDynamicObject(handle);
            }
        }
        return null;
    }

    public ImageRecompressionOptions getImageRecompressionOptions() {
        long retHandle = this.getImageRecompressionOptionsNative(this.getHandle());
        if (retHandle == 0L) {
            switch (Profile.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Profile.throwLastRuntimeException();
        }
        return ImageRecompressionOptions.createDynamicObject(retHandle);
    }

    public FontOptions getFontOptions() {
        long retHandle = this.getFontOptionsNative(this.getHandle());
        if (retHandle == 0L) {
            switch (Profile.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Profile.throwLastRuntimeException();
        }
        return FontOptions.createDynamicObject(retHandle);
    }

    public RemovalOptions getRemovalOptions() {
        long retHandle = this.getRemovalOptionsNative(this.getHandle());
        if (retHandle == 0L) {
            switch (Profile.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Profile.throwLastRuntimeException();
        }
        return RemovalOptions.createDynamicObject(retHandle);
    }

    public boolean getCopyMetadata() {
        boolean retVal = this.getCopyMetadataNative(this.getHandle());
        if (!retVal) {
            switch (Profile.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Profile.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setCopyMetadata(boolean value) {
        boolean retVal = this.setCopyMetadataNative(this.getHandle(), value);
        if (!retVal) {
            switch (Profile.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Profile.throwLastRuntimeException();
        }
    }

    private static native int getType(long var0);

    private native long getImageRecompressionOptionsNative(long var1);

    private native long getFontOptionsNative(long var1);

    private native long getRemovalOptionsNative(long var1);

    private native boolean getCopyMetadataNative(long var1);

    private native boolean setCopyMetadataNative(long var1, boolean var3);
}

