/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.optimization.profiles;

import com.pdftools.optimization.profiles.Profile;

public class Web
extends Profile {
    protected Web(long handle) {
        super(handle);
    }

    public static Web createDynamicObject(long handle) {
        return new Web(handle);
    }

    public Web() {
        this(Web.newHelper());
    }

    private static long newHelper() {
        long handle = Web.newNative();
        if (handle == 0L) {
            switch (Web.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Web.throwLastRuntimeException();
        }
        return handle;
    }

    public Double getResolutionDPI() {
        Double retVal = this.getResolutionDPINative(this.getHandle());
        if (retVal == null) {
            switch (Web.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Web.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setResolutionDPI(Double value) {
        boolean retVal = this.setResolutionDPINative(this.getHandle(), value);
        if (!retVal) {
            switch (Web.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Web.getLastErrorMessage());
                }
            }
            Web.throwLastRuntimeException();
        }
    }

    public double getThresholdDPI() {
        double retVal = this.getThresholdDPINative(this.getHandle());
        if (retVal == 0.0) {
            switch (Web.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Web.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setThresholdDPI(double value) {
        boolean retVal = this.setThresholdDPINative(this.getHandle(), value);
        if (!retVal) {
            switch (Web.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Web.getLastErrorMessage());
                }
            }
            Web.throwLastRuntimeException();
        }
    }

    private static native long newNative();

    private native Double getResolutionDPINative(long var1);

    private native boolean setResolutionDPINative(long var1, Double var3);

    private native double getThresholdDPINative(long var1);

    private native boolean setThresholdDPINative(long var1, double var3);
}

