/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdf;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class Conformance {
    private int value;
    private static Map<Integer, String> toString;
    private static Map<String, Integer> conformances;

    public Conformance(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public Conformance(Version version) {
        block0 : switch (version.getMajor()) {
            case 1: {
                switch (version.getMinor()) {
                    case 0: {
                        this.value = 4096;
                        break block0;
                    }
                    case 1: {
                        this.value = 4352;
                        break block0;
                    }
                    case 2: {
                        this.value = 4608;
                        break block0;
                    }
                    case 3: {
                        this.value = 4864;
                        break block0;
                    }
                    case 4: {
                        this.value = 5120;
                        break block0;
                    }
                    case 5: {
                        this.value = 5376;
                        break block0;
                    }
                    case 6: {
                        this.value = 5632;
                        break block0;
                    }
                    case 7: {
                        this.value = 5888;
                        break block0;
                    }
                }
                throw new IllegalArgumentException(String.format("Invalid version %s.", version.toString()));
            }
            case 2: {
                switch (version.getMinor()) {
                    case 0: {
                        this.value = 8192;
                        break block0;
                    }
                }
                throw new IllegalArgumentException(String.format("Invalid version %s.", version.toString()));
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid version %s.", version.toString()));
            }
        }
    }

    public Conformance(PdfAVersion pdfa) {
        block0 : switch (pdfa.getPart()) {
            case 1: {
                switch (pdfa.getLevel().ordinal()) {
                    case 0: {
                        this.value = 5121;
                        break block0;
                    }
                    case 2: {
                        this.value = 5122;
                        break block0;
                    }
                }
                throw new IllegalArgumentException(String.format("Invalid PDF/A-1 level %s.", pdfa.getLevel().toString()));
            }
            case 2: {
                switch (pdfa.getLevel().ordinal()) {
                    case 0: {
                        this.value = 5889;
                        break block0;
                    }
                    case 1: {
                        this.value = 5890;
                        break block0;
                    }
                    case 2: {
                        this.value = 5891;
                        break block0;
                    }
                }
                throw new IllegalArgumentException(String.format("Invalid PDF/A-2 level %s.", pdfa.getLevel().toString()));
            }
            case 3: {
                switch (pdfa.getLevel().ordinal()) {
                    case 0: {
                        this.value = 5905;
                        break block0;
                    }
                    case 1: {
                        this.value = 5906;
                        break block0;
                    }
                    case 2: {
                        this.value = 5907;
                        break block0;
                    }
                }
                throw new IllegalArgumentException(String.format("Invalid PDF/A-3 level %s.", pdfa.getLevel().toString()));
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid PDF/A part %d.", pdfa.getPart()));
            }
        }
    }

    public Version getVersion() {
        switch (this.value) {
            case 4096: {
                return new Version(1, 0);
            }
            case 4352: {
                return new Version(1, 1);
            }
            case 4608: {
                return new Version(1, 2);
            }
            case 4864: {
                return new Version(1, 3);
            }
            case 5120: 
            case 5121: 
            case 5122: {
                return new Version(1, 4);
            }
            case 5376: {
                return new Version(1, 5);
            }
            case 5632: {
                return new Version(1, 6);
            }
            case 5888: 
            case 5889: 
            case 5890: 
            case 5891: 
            case 5905: 
            case 5906: 
            case 5907: {
                return new Version(1, 7);
            }
            case 8192: {
                return new Version(2, 0);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid conformance %d.", this.value));
    }

    public PdfAVersion getPdfA() {
        switch (this.value) {
            case 5121: {
                return new PdfAVersion(1, PdfAVersion.Level.B);
            }
            case 5122: {
                return new PdfAVersion(1, PdfAVersion.Level.A);
            }
            case 5889: {
                return new PdfAVersion(2, PdfAVersion.Level.B);
            }
            case 5890: {
                return new PdfAVersion(2, PdfAVersion.Level.U);
            }
            case 5891: {
                return new PdfAVersion(2, PdfAVersion.Level.A);
            }
            case 5905: {
                return new PdfAVersion(3, PdfAVersion.Level.B);
            }
            case 5906: {
                return new PdfAVersion(3, PdfAVersion.Level.U);
            }
            case 5907: {
                return new PdfAVersion(3, PdfAVersion.Level.A);
            }
        }
        return null;
    }

    public boolean conformsTo(Conformance other) {
        PdfAVersion a1 = this.getPdfA();
        PdfAVersion a2 = other.getPdfA();
        if (a1 != null) {
            if (a2 != null) {
                return a1.part == a2.part && a1.level.getValue() >= a2.level.getValue();
            }
            return this.getVersion().equals(other.getVersion());
        }
        if (a2 != null) {
            return false;
        }
        return this.getVersion().equals(other.getVersion());
    }

    public String toString() {
        String result = toString.get(this.value);
        if (result == null) {
            throw new IllegalArgumentException(String.format("Invalid conformance %d.", this.value));
        }
        return result;
    }

    public static Conformance parse(String conformance) {
        Integer result = conformances.get(conformance);
        if (result == null) {
            throw new IllegalArgumentException(String.format("Invalid conformance %s.", conformance));
        }
        return new Conformance(result);
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof Conformance) {
            return ((Conformance)other).value == this.value;
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    static {
        ConcurrentHashMap<Integer, String> toStringMap = new ConcurrentHashMap<Integer, String>(){
            {
                this.put(5891, "PDF/A-2a");
                this.put(5889, "PDF/A-2b");
                this.put(5890, "PDF/A-2u");
                this.put(5907, "PDF/A-3a");
                this.put(5905, "PDF/A-3b");
                this.put(5906, "PDF/A-3u");
                this.put(5122, "PDF/A-1a");
                this.put(5121, "PDF/A-1b");
                this.put(5120, "PDF 1.4");
                this.put(5376, "PDF 1.5");
                this.put(5632, "PDF 1.6");
                this.put(5888, "PDF 1.7");
                this.put(8192, "PDF 2.0");
                this.put(4096, "PDF 1.0");
                this.put(4352, "PDF 1.1");
                this.put(4608, "PDF 1.2");
                this.put(4864, "PDF 1.3");
            }
        };
        toString = Collections.unmodifiableMap(toStringMap);
        ConcurrentHashMap<String, Integer> conformancesMap = new ConcurrentHashMap<String, Integer>();
        for (Map.Entry<Integer, String> entry : toString.entrySet()) {
            conformancesMap.put(entry.getValue(), entry.getKey());
        }
        conformances = Collections.unmodifiableMap(conformancesMap);
    }

    public static class Version
    implements Comparable<Version> {
        private int major;
        private int minor;

        public Version(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public String toString() {
            return String.format("%d.%d", this.major, this.minor);
        }

        public boolean equals(Object other) {
            if (other != null && other instanceof Version) {
                if (((Version)other).major != this.major) {
                    return false;
                }
                return ((Version)other).minor == this.minor;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.major, this.minor);
        }

        @Override
        public int compareTo(Version o) {
            if (this.major != o.major) {
                return this.major - o.major;
            }
            return this.minor - o.minor;
        }
    }

    private static class COMPLIANCE {
        public static final int ePDF10 = 4096;
        public static final int ePDF11 = 4352;
        public static final int ePDF12 = 4608;
        public static final int ePDF13 = 4864;
        public static final int ePDF14 = 5120;
        public static final int ePDF15 = 5376;
        public static final int ePDF16 = 5632;
        public static final int ePDF17 = 5888;
        public static final int ePDF20 = 8192;
        public static final int ePDFA1b = 5121;
        public static final int ePDFA1a = 5122;
        public static final int ePDFA2b = 5889;
        public static final int ePDFA2u = 5890;
        public static final int ePDFA2a = 5891;
        public static final int ePDFA3b = 5905;
        public static final int ePDFA3u = 5906;
        public static final int ePDFA3a = 5907;

        private COMPLIANCE() {
        }
    }

    public static class PdfAVersion
    implements Comparable<PdfAVersion> {
        private int part;
        private Level level;

        public PdfAVersion(int part, Level level) {
            this.part = part;
            this.level = level;
        }

        public int getPart() {
            return this.part;
        }

        public Level getLevel() {
            return this.level;
        }

        public String toString() {
            return String.format("PFD/A-%d%s", this.part, this.level.toString().toLowerCase());
        }

        public boolean equals(Object other) {
            if (other != null && other instanceof PdfAVersion) {
                if (((PdfAVersion)other).part != this.part) {
                    return false;
                }
                return ((PdfAVersion)other).level == this.level;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.part, this.level});
        }

        @Override
        public int compareTo(PdfAVersion o) {
            if (this.part != o.part) {
                return this.part - o.part;
            }
            return this.level.getValue() - o.level.getValue();
        }

        public static enum Level {
            B(1),
            U(2),
            A(3);

            private int value;

            private Level(int value) {
                this.value = value;
            }

            public int getValue() {
                return this.value;
            }

            public String toString() {
                switch (this.ordinal()) {
                    case 0: {
                        return "B";
                    }
                    case 1: {
                        return "U";
                    }
                    case 2: {
                        return "A";
                    }
                }
                throw new IllegalArgumentException(String.format("Invalid PDF/A level %d.", this.value));
            }
        }
    }
}

