/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdf;

import com.pdftools.CorruptException;
import com.pdftools.GenericException;
import com.pdftools.LicenseException;
import com.pdftools.PasswordException;
import com.pdftools.PdfToolsException;
import com.pdftools.UnsupportedFeatureException;
import com.pdftools.internal.NativeObject;
import com.pdftools.pdf.Conformance;
import com.pdftools.pdf.Metadata;
import com.pdftools.pdf.Permission;
import com.pdftools.pdf.SignatureFieldList;
import com.pdftools.pdf.XfaType;
import com.pdftools.sign.PreparedDocument;
import com.pdftools.sys.Stream;
import java.io.IOException;
import java.util.EnumSet;

public class Document
extends NativeObject
implements AutoCloseable {
    protected Document(long handle) {
        super(handle);
    }

    public static Document createDynamicObject(long handle) {
        int type = Document.getType(handle);
        switch (type) {
            case 0: {
                return new Document(handle);
            }
            case 1: {
                return PreparedDocument.createDynamicObject(handle);
            }
        }
        return null;
    }

    public static Document open(Stream stream) throws GenericException, LicenseException, CorruptException, PasswordException, UnsupportedFeatureException {
        if (stream == null) {
            throw new IllegalArgumentException("Argument 'stream' must not be null.", new NullPointerException("'stream'"));
        }
        return Document.open(stream, null);
    }

    public static Document open(Stream stream, String password) throws GenericException, LicenseException, CorruptException, PasswordException, UnsupportedFeatureException {
        if (stream == null) {
            throw new IllegalArgumentException("Argument 'stream' must not be null.", new NullPointerException("'stream'"));
        }
        long retHandle = Document.openNative(stream, password);
        if (retHandle == 0L) {
            switch (Document.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 10: {
                    throw new GenericException(Document.getLastErrorMessage());
                }
                case 12: {
                    throw new LicenseException(Document.getLastErrorMessage());
                }
                case 16: {
                    throw new CorruptException(Document.getLastErrorMessage());
                }
                case 17: {
                    throw new PasswordException(Document.getLastErrorMessage());
                }
                case 19: {
                    throw new UnsupportedFeatureException(Document.getLastErrorMessage());
                }
            }
            Document.throwLastRuntimeException();
        }
        return Document.createDynamicObject(retHandle);
    }

    public Conformance getConformance() {
        Integer retVal = this.getConformanceNative(this.getHandle());
        if (retVal == null) {
            switch (Document.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Document.throwLastRuntimeException();
                }
            }
            return null;
        }
        return new Conformance(retVal);
    }

    public int getPageCount() {
        int retVal = this.getPageCountNative(this.getHandle());
        if (retVal == -1) {
            switch (Document.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Document.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public EnumSet<Permission> getPermissions() {
        Integer retVal = this.getPermissionsNative(this.getHandle());
        if (retVal == null) {
            switch (Document.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Document.throwLastRuntimeException();
                }
            }
            return null;
        }
        return Document.getEnumSet(retVal, Permission.class);
    }

    public boolean getIsLinearized() {
        boolean retVal = this.getIsLinearizedNative(this.getHandle());
        if (!retVal) {
            switch (Document.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Document.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public boolean getIsSigned() {
        boolean retVal = this.getIsSignedNative(this.getHandle());
        if (!retVal) {
            switch (Document.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Document.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public SignatureFieldList getSignatureFields() {
        long retHandle = this.getSignatureFieldsNative(this.getHandle());
        if (retHandle == 0L) {
            switch (Document.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Document.throwLastRuntimeException();
        }
        return SignatureFieldList.createDynamicObject(retHandle);
    }

    public XfaType getXfa() {
        int retVal = this.getXfaNative(this.getHandle());
        if (retVal == 0) {
            switch (Document.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Document.throwLastRuntimeException();
                }
            }
        }
        return XfaType.fromValue(retVal);
    }

    public Metadata getMetadata() {
        long retHandle = this.getMetadataNative(this.getHandle());
        if (retHandle == 0L) {
            switch (Document.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Document.throwLastRuntimeException();
        }
        return Metadata.createDynamicObject(retHandle);
    }

    private static native int getType(long var0);

    private static native long openNative(Stream var0, String var1);

    private native Integer getConformanceNative(long var1);

    private native int getPageCountNative(long var1);

    private native Integer getPermissionsNative(long var1);

    private native boolean getIsLinearizedNative(long var1);

    private native boolean getIsSignedNative(long var1);

    private native long getSignatureFieldsNative(long var1);

    private native int getXfaNative(long var1);

    private native long getMetadataNative(long var1);

    @Override
    public void close() throws PdfToolsException, IOException {
        try {
            if (!this.close(this.getHandle())) {
                Document.throwLastError();
            }
        }
        finally {
            this.setHandle(0L);
        }
    }

    private native boolean close(long var1);
}

