/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdf;

import com.pdftools.internal.NativeObject;
import com.pdftools.pdf.Permission;
import java.util.EnumSet;

public class Encryption
extends NativeObject {
    protected Encryption(long handle) {
        super(handle);
    }

    public static Encryption createDynamicObject(long handle) {
        return new Encryption(handle);
    }

    public Encryption(String userPassword, String ownerPassword, EnumSet<Permission> permissions) {
        this(Encryption.newHelper(userPassword, ownerPassword, permissions));
    }

    private static long newHelper(String userPassword, String ownerPassword, EnumSet<Permission> permissions) {
        if (permissions == null) {
            throw new IllegalArgumentException("Argument 'permissions' must not be null.", new NullPointerException("'permissions'"));
        }
        long handle = Encryption.newNative(userPassword, ownerPassword, Encryption.getFlags(permissions));
        if (handle == 0L) {
            switch (Encryption.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Encryption.throwLastRuntimeException();
        }
        return handle;
    }

    public void setPermissions(String ownerPassword, EnumSet<Permission> permissions) {
        if (ownerPassword == null) {
            throw new IllegalArgumentException("Argument 'ownerPassword' must not be null.", new NullPointerException("'ownerPassword'"));
        }
        if (permissions == null) {
            throw new IllegalArgumentException("Argument 'permissions' must not be null.", new NullPointerException("'permissions'"));
        }
        boolean retVal = this.setPermissionsNative(this.getHandle(), ownerPassword, Encryption.getFlags(permissions));
        if (!retVal) {
            switch (Encryption.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Encryption.getLastErrorMessage());
                }
            }
            Encryption.throwLastRuntimeException();
        }
    }

    public String getUserPassword() {
        String retVal = this.getUserPasswordNative(this.getHandle());
        if (retVal == null) {
            switch (Encryption.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Encryption.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setUserPassword(String value) {
        boolean retVal = this.setUserPasswordNative(this.getHandle(), value);
        if (!retVal) {
            switch (Encryption.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Encryption.throwLastRuntimeException();
        }
    }

    public String getOwnerPassword() {
        String retVal = this.getOwnerPasswordNative(this.getHandle());
        if (retVal == null) {
            switch (Encryption.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Encryption.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public EnumSet<Permission> getPermissions() {
        int retVal = this.getPermissionsNative(this.getHandle());
        if (retVal == 0) {
            switch (Encryption.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Encryption.throwLastRuntimeException();
                }
            }
        }
        return Encryption.getEnumSet(retVal, Permission.class);
    }

    private static native long newNative(String var0, String var1, int var2);

    private native boolean setPermissionsNative(long var1, String var3, int var4);

    private native String getUserPasswordNative(long var1);

    private native boolean setUserPasswordNative(long var1, String var3);

    private native String getOwnerPasswordNative(long var1);

    private native int getPermissionsNative(long var1);
}

