/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdf;

import com.pdftools.internal.NativeObject;
import com.pdftools.pdf.Encryption;
import com.pdftools.pdf.MetadataSettings;

public class OutputOptions
extends NativeObject {
    protected OutputOptions(long handle) {
        super(handle);
    }

    public static OutputOptions createDynamicObject(long handle) {
        int type = OutputOptions.getType(handle);
        switch (type) {
            case 0: {
                return new OutputOptions(handle);
            }
            case 1: {
                return com.pdftools.sign.OutputOptions.createDynamicObject(handle);
            }
        }
        return null;
    }

    public OutputOptions() {
        this(OutputOptions.newHelper());
    }

    private static long newHelper() {
        long handle = OutputOptions.newNative();
        if (handle == 0L) {
            switch (OutputOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            OutputOptions.throwLastRuntimeException();
        }
        return handle;
    }

    public Encryption getEncryption() {
        long retHandle = this.getEncryptionNative(this.getHandle());
        if (retHandle == 0L) {
            switch (OutputOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    OutputOptions.throwLastRuntimeException();
                }
            }
            return null;
        }
        return Encryption.createDynamicObject(retHandle);
    }

    public void setEncryption(Encryption value) {
        boolean retVal = this.setEncryptionNative(this.getHandle(), OutputOptions.getHandle(value), value);
        if (!retVal) {
            switch (OutputOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            OutputOptions.throwLastRuntimeException();
        }
    }

    public MetadataSettings getMetadataSettings() {
        long retHandle = this.getMetadataSettingsNative(this.getHandle());
        if (retHandle == 0L) {
            switch (OutputOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    OutputOptions.throwLastRuntimeException();
                }
            }
            return null;
        }
        return MetadataSettings.createDynamicObject(retHandle);
    }

    public void setMetadataSettings(MetadataSettings value) {
        boolean retVal = this.setMetadataSettingsNative(this.getHandle(), OutputOptions.getHandle(value), value);
        if (!retVal) {
            switch (OutputOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            OutputOptions.throwLastRuntimeException();
        }
    }

    private static native int getType(long var0);

    private static native long newNative();

    private native long getEncryptionNative(long var1);

    private native boolean setEncryptionNative(long var1, long var3, Encryption var5);

    private native long getMetadataSettingsNative(long var1);

    private native boolean setMetadataSettingsNative(long var1, long var3, MetadataSettings var5);
}

