/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdf;

import com.pdftools.pdf.CertificationSignature;
import com.pdftools.pdf.DocumentSignature;
import com.pdftools.pdf.SignedSignatureField;

public abstract class Signature
extends SignedSignatureField {
    protected Signature(long handle) {
        super(handle);
    }

    public static Signature createDynamicObject(long handle) {
        int type = Signature.getType(handle);
        switch (type) {
            case 1: {
                return DocumentSignature.createDynamicObject(handle);
            }
            case 2: {
                return CertificationSignature.createDynamicObject(handle);
            }
        }
        return null;
    }

    public String getLocation() {
        String retVal = this.getLocationNative(this.getHandle());
        if (retVal == null) {
            switch (Signature.getLastErrorCode()) {
                case 0: {
                    break;
                }
                case 2: {
                    throw new IllegalStateException(Signature.getLastErrorMessage());
                }
                default: {
                    Signature.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public String getReason() {
        String retVal = this.getReasonNative(this.getHandle());
        if (retVal == null) {
            switch (Signature.getLastErrorCode()) {
                case 0: {
                    break;
                }
                case 2: {
                    throw new IllegalStateException(Signature.getLastErrorMessage());
                }
                default: {
                    Signature.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public String getContactInfo() {
        String retVal = this.getContactInfoNative(this.getHandle());
        if (retVal == null) {
            switch (Signature.getLastErrorCode()) {
                case 0: {
                    break;
                }
                case 2: {
                    throw new IllegalStateException(Signature.getLastErrorMessage());
                }
                default: {
                    Signature.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    private static native int getType(long var0);

    private native String getLocationNative(long var1);

    private native String getReasonNative(long var1);

    private native String getContactInfoNative(long var1);
}

