/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdf;

import com.pdftools.NotFoundException;
import com.pdftools.geometry.units.Rectangle;
import com.pdftools.internal.NativeObject;
import com.pdftools.pdf.CertificationSignature;
import com.pdftools.pdf.DocumentSignature;
import com.pdftools.pdf.DocumentTimestamp;
import com.pdftools.pdf.UnsignedSignatureField;

public abstract class SignatureField
extends NativeObject {
    protected SignatureField(long handle) {
        super(handle);
    }

    public static SignatureField createDynamicObject(long handle) {
        int type = SignatureField.getType(handle);
        switch (type) {
            case 1: {
                return UnsignedSignatureField.createDynamicObject(handle);
            }
            case 4: {
                return DocumentSignature.createDynamicObject(handle);
            }
            case 5: {
                return CertificationSignature.createDynamicObject(handle);
            }
            case 6: {
                return DocumentTimestamp.createDynamicObject(handle);
            }
        }
        return null;
    }

    public String getFieldName() {
        String retVal = this.getFieldNameNative(this.getHandle());
        if (retVal == null) {
            switch (SignatureField.getLastErrorCode()) {
                case 0: {
                    break;
                }
                case 2: {
                    throw new IllegalStateException(SignatureField.getLastErrorMessage());
                }
                default: {
                    SignatureField.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public int getPageNumber() throws NotFoundException {
        int retVal = this.getPageNumberNative(this.getHandle());
        if (retVal == 0) {
            switch (SignatureField.getLastErrorCode()) {
                case 0: {
                    break;
                }
                case 2: {
                    throw new IllegalStateException(SignatureField.getLastErrorMessage());
                }
                case 5: {
                    throw new NotFoundException(SignatureField.getLastErrorMessage());
                }
                default: {
                    SignatureField.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public Rectangle getBoundingBox() {
        Rectangle retVal = this.getBoundingBoxNative(this.getHandle());
        if (retVal == null) {
            switch (SignatureField.getLastErrorCode()) {
                case 0: {
                    break;
                }
                case 2: {
                    throw new IllegalStateException(SignatureField.getLastErrorMessage());
                }
                default: {
                    SignatureField.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    private static native int getType(long var0);

    private native String getFieldNameNative(long var1);

    private native int getPageNumberNative(long var1);

    private native Rectangle getBoundingBoxNative(long var1);
}

