/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdf;

import com.pdftools.CorruptException;
import com.pdftools.pdf.CertificationSignature;
import com.pdftools.pdf.DocumentSignature;
import com.pdftools.pdf.DocumentTimestamp;
import com.pdftools.pdf.Revision;
import com.pdftools.pdf.SignatureField;
import java.time.OffsetDateTime;

public abstract class SignedSignatureField
extends SignatureField {
    protected SignedSignatureField(long handle) {
        super(handle);
    }

    public static SignedSignatureField createDynamicObject(long handle) {
        int type = SignedSignatureField.getType(handle);
        switch (type) {
            case 2: {
                return DocumentSignature.createDynamicObject(handle);
            }
            case 3: {
                return CertificationSignature.createDynamicObject(handle);
            }
            case 4: {
                return DocumentTimestamp.createDynamicObject(handle);
            }
        }
        return null;
    }

    public String getName() {
        String retVal = this.getNameNative(this.getHandle());
        if (retVal == null) {
            switch (SignedSignatureField.getLastErrorCode()) {
                case 0: {
                    break;
                }
                case 2: {
                    throw new IllegalStateException(SignedSignatureField.getLastErrorMessage());
                }
                default: {
                    SignedSignatureField.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public OffsetDateTime getDate() {
        OffsetDateTime retVal = this.getDateNative(this.getHandle());
        if (retVal == null) {
            switch (SignedSignatureField.getLastErrorCode()) {
                case 0: {
                    break;
                }
                case 2: {
                    throw new IllegalStateException(SignedSignatureField.getLastErrorMessage());
                }
                default: {
                    SignedSignatureField.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public Revision getRevision() throws CorruptException {
        long retHandle = this.getRevisionNative(this.getHandle());
        if (retHandle == 0L) {
            switch (SignedSignatureField.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 2: {
                    throw new IllegalStateException(SignedSignatureField.getLastErrorMessage());
                }
                case 16: {
                    throw new CorruptException(SignedSignatureField.getLastErrorMessage());
                }
            }
            SignedSignatureField.throwLastRuntimeException();
        }
        return Revision.createDynamicObject(retHandle);
    }

    private static native int getType(long var0);

    private native String getNameNative(long var1);

    private native OffsetDateTime getDateNative(long var1);

    private native long getRevisionNative(long var1);
}

