/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdf2image;

import com.pdftools.GenericException;
import com.pdftools.LicenseException;
import com.pdftools.ProcessingException;
import com.pdftools.UnsupportedFeatureException;
import com.pdftools.image.MultiPageDocument;
import com.pdftools.internal.NativeObject;
import com.pdftools.pdf.Document;
import com.pdftools.pdf2image.profiles.Profile;
import com.pdftools.sys.Stream;
import java.io.IOException;

public class Converter
extends NativeObject {
    protected Converter(long handle) {
        super(handle);
    }

    public static Converter createDynamicObject(long handle) {
        return new Converter(handle);
    }

    public Converter() {
        this(Converter.newHelper());
    }

    private static long newHelper() {
        long handle = Converter.newNative();
        if (handle == 0L) {
            switch (Converter.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Converter.throwLastRuntimeException();
        }
        return handle;
    }

    public MultiPageDocument convertDocument(Document inDoc, Stream outStream, Profile profile) throws IOException, GenericException, LicenseException, UnsupportedFeatureException, ProcessingException {
        if (inDoc == null) {
            throw new IllegalArgumentException("Argument 'inDoc' must not be null.", new NullPointerException("'inDoc'"));
        }
        if (outStream == null) {
            throw new IllegalArgumentException("Argument 'outStream' must not be null.", new NullPointerException("'outStream'"));
        }
        if (profile == null) {
            throw new IllegalArgumentException("Argument 'profile' must not be null.", new NullPointerException("'profile'"));
        }
        long retHandle = this.convertDocumentNative(this.getHandle(), Converter.getHandle(inDoc), inDoc, outStream, Converter.getHandle(profile), profile);
        if (retHandle == 0L) {
            switch (Converter.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 2: {
                    throw new IllegalStateException(Converter.getLastErrorMessage());
                }
                case 3: {
                    throw new IllegalArgumentException(Converter.getLastErrorMessage());
                }
                case 4: {
                    throw new IOException(Converter.getLastErrorMessage());
                }
                case 10: {
                    throw new GenericException(Converter.getLastErrorMessage());
                }
                case 12: {
                    throw new LicenseException(Converter.getLastErrorMessage());
                }
                case 19: {
                    throw new UnsupportedFeatureException(Converter.getLastErrorMessage());
                }
                case 21: {
                    throw new ProcessingException(Converter.getLastErrorMessage());
                }
            }
            Converter.throwLastRuntimeException();
        }
        return MultiPageDocument.createDynamicObject(retHandle);
    }

    public com.pdftools.image.Document convertPage(Document inDoc, Stream outStream, Profile profile, int pageNumber) throws IOException, GenericException, LicenseException, UnsupportedFeatureException, ProcessingException {
        if (inDoc == null) {
            throw new IllegalArgumentException("Argument 'inDoc' must not be null.", new NullPointerException("'inDoc'"));
        }
        if (outStream == null) {
            throw new IllegalArgumentException("Argument 'outStream' must not be null.", new NullPointerException("'outStream'"));
        }
        if (profile == null) {
            throw new IllegalArgumentException("Argument 'profile' must not be null.", new NullPointerException("'profile'"));
        }
        long retHandle = this.convertPageNative(this.getHandle(), Converter.getHandle(inDoc), inDoc, outStream, Converter.getHandle(profile), profile, pageNumber);
        if (retHandle == 0L) {
            switch (Converter.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Converter.getLastErrorMessage());
                }
                case 4: {
                    throw new IOException(Converter.getLastErrorMessage());
                }
                case 10: {
                    throw new GenericException(Converter.getLastErrorMessage());
                }
                case 12: {
                    throw new LicenseException(Converter.getLastErrorMessage());
                }
                case 19: {
                    throw new UnsupportedFeatureException(Converter.getLastErrorMessage());
                }
                case 21: {
                    throw new ProcessingException(Converter.getLastErrorMessage());
                }
            }
            Converter.throwLastRuntimeException();
        }
        return com.pdftools.image.Document.createDynamicObject(retHandle);
    }

    private static native long newNative();

    private native long convertDocumentNative(long var1, long var3, Document var5, Stream var6, long var7, Profile var9);

    private native long convertPageNative(long var1, long var3, Document var5, Stream var6, long var7, Profile var9, int var10);
}

