/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdf2image;

import com.pdftools.pdf2image.FaxVerticalResolution;
import com.pdftools.pdf2image.ImageOptions;
import com.pdftools.pdf2image.TiffBitonalCompressionType;

public class FaxImageOptions
extends ImageOptions {
    protected FaxImageOptions(long handle) {
        super(handle);
    }

    public static FaxImageOptions createDynamicObject(long handle) {
        return new FaxImageOptions(handle);
    }

    public FaxVerticalResolution getVerticalResolution() {
        int retVal = this.getVerticalResolutionNative(this.getHandle());
        if (retVal == 0) {
            switch (FaxImageOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    FaxImageOptions.throwLastRuntimeException();
                }
            }
        }
        return FaxVerticalResolution.fromValue(retVal);
    }

    public void setVerticalResolution(FaxVerticalResolution value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setVerticalResolutionNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (FaxImageOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            FaxImageOptions.throwLastRuntimeException();
        }
    }

    public TiffBitonalCompressionType getCompression() {
        int retVal = this.getCompressionNative(this.getHandle());
        if (retVal == 0) {
            switch (FaxImageOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    FaxImageOptions.throwLastRuntimeException();
                }
            }
        }
        return TiffBitonalCompressionType.fromValue(retVal);
    }

    public void setCompression(TiffBitonalCompressionType value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setCompressionNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (FaxImageOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            FaxImageOptions.throwLastRuntimeException();
        }
    }

    private native int getVerticalResolutionNative(long var1);

    private native boolean setVerticalResolutionNative(long var1, int var3);

    private native int getCompressionNative(long var1);

    private native boolean setCompressionNative(long var1, int var3);
}

