/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdf2image;

import com.pdftools.pdf2image.ImageOptions;
import com.pdftools.pdf2image.JpegColorSpace;

public class JpegImageOptions
extends ImageOptions {
    protected JpegImageOptions(long handle) {
        super(handle);
    }

    public static JpegImageOptions createDynamicObject(long handle) {
        return new JpegImageOptions(handle);
    }

    public JpegImageOptions() {
        this(JpegImageOptions.newHelper());
    }

    private static long newHelper() {
        long handle = JpegImageOptions.newNative();
        if (handle == 0L) {
            switch (JpegImageOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            JpegImageOptions.throwLastRuntimeException();
        }
        return handle;
    }

    public JpegColorSpace getColorSpace() {
        Integer retVal = this.getColorSpaceNative(this.getHandle());
        if (retVal == null) {
            switch (JpegImageOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    JpegImageOptions.throwLastRuntimeException();
                }
            }
            return null;
        }
        return JpegColorSpace.fromValue(retVal);
    }

    public void setColorSpace(JpegColorSpace value) {
        boolean retVal = this.setColorSpaceNative(this.getHandle(), value == null ? 0 : value.getValue(), value == null);
        if (!retVal) {
            switch (JpegImageOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            JpegImageOptions.throwLastRuntimeException();
        }
    }

    public int getJpegQuality() {
        int retVal = this.getJpegQualityNative(this.getHandle());
        if (retVal == 0) {
            switch (JpegImageOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    JpegImageOptions.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setJpegQuality(int value) {
        boolean retVal = this.setJpegQualityNative(this.getHandle(), value);
        if (!retVal) {
            switch (JpegImageOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(JpegImageOptions.getLastErrorMessage());
                }
            }
            JpegImageOptions.throwLastRuntimeException();
        }
    }

    private static native long newNative();

    private native Integer getColorSpaceNative(long var1);

    private native boolean setColorSpaceNative(long var1, int var3, boolean var4);

    private native int getJpegQualityNative(long var1);

    private native boolean setJpegQualityNative(long var1, int var3);
}

