/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdf2image;

import com.pdftools.pdf2image.BackgroundType;
import com.pdftools.pdf2image.ImageOptions;
import com.pdftools.pdf2image.PngColorSpace;

public class PngImageOptions
extends ImageOptions {
    protected PngImageOptions(long handle) {
        super(handle);
    }

    public static PngImageOptions createDynamicObject(long handle) {
        return new PngImageOptions(handle);
    }

    public PngImageOptions() {
        this(PngImageOptions.newHelper());
    }

    private static long newHelper() {
        long handle = PngImageOptions.newNative();
        if (handle == 0L) {
            switch (PngImageOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            PngImageOptions.throwLastRuntimeException();
        }
        return handle;
    }

    public BackgroundType getBackground() {
        int retVal = this.getBackgroundNative(this.getHandle());
        if (retVal == 0) {
            switch (PngImageOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    PngImageOptions.throwLastRuntimeException();
                }
            }
        }
        return BackgroundType.fromValue(retVal);
    }

    public void setBackground(BackgroundType value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setBackgroundNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (PngImageOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            PngImageOptions.throwLastRuntimeException();
        }
    }

    public PngColorSpace getColorSpace() {
        int retVal = this.getColorSpaceNative(this.getHandle());
        if (retVal == 0) {
            switch (PngImageOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    PngImageOptions.throwLastRuntimeException();
                }
            }
        }
        return PngColorSpace.fromValue(retVal);
    }

    public void setColorSpace(PngColorSpace value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setColorSpaceNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (PngImageOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            PngImageOptions.throwLastRuntimeException();
        }
    }

    private static native long newNative();

    private native int getBackgroundNative(long var1);

    private native boolean setBackgroundNative(long var1, int var3);

    private native int getColorSpaceNative(long var1);

    private native boolean setColorSpaceNative(long var1, int var3);
}

