/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdf2image;

import com.pdftools.geometry.units.Resolution;
import com.pdftools.pdf2image.ImageSectionMapping;

public class RenderPageAtResolution
extends ImageSectionMapping {
    protected RenderPageAtResolution(long handle) {
        super(handle);
    }

    public static RenderPageAtResolution createDynamicObject(long handle) {
        return new RenderPageAtResolution(handle);
    }

    public RenderPageAtResolution(Resolution resolution) {
        this(RenderPageAtResolution.newHelper(resolution));
    }

    private static long newHelper(Resolution resolution) {
        if (resolution == null) {
            throw new IllegalArgumentException("Argument 'resolution' must not be null.", new NullPointerException("'resolution'"));
        }
        long handle = RenderPageAtResolution.newNative(resolution.getXDpi(), resolution.getYDpi());
        if (handle == 0L) {
            switch (RenderPageAtResolution.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(RenderPageAtResolution.getLastErrorMessage());
                }
            }
            RenderPageAtResolution.throwLastRuntimeException();
        }
        return handle;
    }

    public Resolution getResolution() {
        Resolution retVal = this.getResolutionNative(this.getHandle());
        if (retVal == null) {
            switch (RenderPageAtResolution.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            RenderPageAtResolution.throwLastRuntimeException();
        }
        return retVal;
    }

    public void setResolution(Resolution value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setResolutionNative(this.getHandle(), value.getXDpi(), value.getYDpi());
        if (!retVal) {
            switch (RenderPageAtResolution.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            RenderPageAtResolution.throwLastRuntimeException();
        }
    }

    private static native long newNative(double var0, double var2);

    private native Resolution getResolutionNative(long var1);

    private native boolean setResolutionNative(long var1, double var3, double var5);
}

