/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdf2image;

import com.pdftools.geometry.integer.Size;
import com.pdftools.pdf2image.ImageSectionMapping;

public class RenderPageToMaxImageSize
extends ImageSectionMapping {
    protected RenderPageToMaxImageSize(long handle) {
        super(handle);
    }

    public static RenderPageToMaxImageSize createDynamicObject(long handle) {
        return new RenderPageToMaxImageSize(handle);
    }

    public RenderPageToMaxImageSize(Size size) {
        this(RenderPageToMaxImageSize.newHelper(size));
    }

    private static long newHelper(Size size) {
        if (size == null) {
            throw new IllegalArgumentException("Argument 'size' must not be null.", new NullPointerException("'size'"));
        }
        long handle = RenderPageToMaxImageSize.newNative(size.getWidth(), size.getHeight());
        if (handle == 0L) {
            switch (RenderPageToMaxImageSize.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(RenderPageToMaxImageSize.getLastErrorMessage());
                }
            }
            RenderPageToMaxImageSize.throwLastRuntimeException();
        }
        return handle;
    }

    public Size getSize() {
        Size retVal = this.getSizeNative(this.getHandle());
        if (retVal == null) {
            switch (RenderPageToMaxImageSize.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            RenderPageToMaxImageSize.throwLastRuntimeException();
        }
        return retVal;
    }

    public void setSize(Size value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setSizeNative(this.getHandle(), value.getWidth(), value.getHeight());
        if (!retVal) {
            switch (RenderPageToMaxImageSize.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(RenderPageToMaxImageSize.getLastErrorMessage());
                }
            }
            RenderPageToMaxImageSize.throwLastRuntimeException();
        }
    }

    private static native long newNative(int var0, int var1);

    private native Size getSizeNative(long var1);

    private native boolean setSizeNative(long var1, int var3, int var4);
}

