/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdf2image;

import com.pdftools.pdf2image.BackgroundType;
import com.pdftools.pdf2image.ColorSpace;
import com.pdftools.pdf2image.ImageOptions;

public class TiffFlateImageOptions
extends ImageOptions {
    protected TiffFlateImageOptions(long handle) {
        super(handle);
    }

    public static TiffFlateImageOptions createDynamicObject(long handle) {
        return new TiffFlateImageOptions(handle);
    }

    public TiffFlateImageOptions() {
        this(TiffFlateImageOptions.newHelper());
    }

    private static long newHelper() {
        long handle = TiffFlateImageOptions.newNative();
        if (handle == 0L) {
            switch (TiffFlateImageOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            TiffFlateImageOptions.throwLastRuntimeException();
        }
        return handle;
    }

    public BackgroundType getBackground() {
        int retVal = this.getBackgroundNative(this.getHandle());
        if (retVal == 0) {
            switch (TiffFlateImageOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    TiffFlateImageOptions.throwLastRuntimeException();
                }
            }
        }
        return BackgroundType.fromValue(retVal);
    }

    public void setBackground(BackgroundType value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setBackgroundNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (TiffFlateImageOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            TiffFlateImageOptions.throwLastRuntimeException();
        }
    }

    public ColorSpace getColorSpace() {
        Integer retVal = this.getColorSpaceNative(this.getHandle());
        if (retVal == null) {
            switch (TiffFlateImageOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    TiffFlateImageOptions.throwLastRuntimeException();
                }
            }
            return null;
        }
        return ColorSpace.fromValue(retVal);
    }

    public void setColorSpace(ColorSpace value) {
        boolean retVal = this.setColorSpaceNative(this.getHandle(), value == null ? 0 : value.getValue(), value == null);
        if (!retVal) {
            switch (TiffFlateImageOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            TiffFlateImageOptions.throwLastRuntimeException();
        }
    }

    private static native long newNative();

    private native int getBackgroundNative(long var1);

    private native boolean setBackgroundNative(long var1, int var3);

    private native Integer getColorSpaceNative(long var1);

    private native boolean setColorSpaceNative(long var1, int var3, boolean var4);
}

