/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdf2image;

import com.pdftools.pdf2image.ImageOptions;
import com.pdftools.pdf2image.JpegColorSpace;

public class TiffJpegImageOptions
extends ImageOptions {
    protected TiffJpegImageOptions(long handle) {
        super(handle);
    }

    public static TiffJpegImageOptions createDynamicObject(long handle) {
        return new TiffJpegImageOptions(handle);
    }

    public TiffJpegImageOptions() {
        this(TiffJpegImageOptions.newHelper());
    }

    private static long newHelper() {
        long handle = TiffJpegImageOptions.newNative();
        if (handle == 0L) {
            switch (TiffJpegImageOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            TiffJpegImageOptions.throwLastRuntimeException();
        }
        return handle;
    }

    public int getJpegQuality() {
        int retVal = this.getJpegQualityNative(this.getHandle());
        if (retVal == 0) {
            switch (TiffJpegImageOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    TiffJpegImageOptions.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setJpegQuality(int value) {
        boolean retVal = this.setJpegQualityNative(this.getHandle(), value);
        if (!retVal) {
            switch (TiffJpegImageOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(TiffJpegImageOptions.getLastErrorMessage());
                }
            }
            TiffJpegImageOptions.throwLastRuntimeException();
        }
    }

    public JpegColorSpace getColorSpace() {
        Integer retVal = this.getColorSpaceNative(this.getHandle());
        if (retVal == null) {
            switch (TiffJpegImageOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    TiffJpegImageOptions.throwLastRuntimeException();
                }
            }
            return null;
        }
        return JpegColorSpace.fromValue(retVal);
    }

    public void setColorSpace(JpegColorSpace value) {
        boolean retVal = this.setColorSpaceNative(this.getHandle(), value == null ? 0 : value.getValue(), value == null);
        if (!retVal) {
            switch (TiffJpegImageOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            TiffJpegImageOptions.throwLastRuntimeException();
        }
    }

    private static native long newNative();

    private native int getJpegQualityNative(long var1);

    private native boolean setJpegQualityNative(long var1, int var3);

    private native Integer getColorSpaceNative(long var1);

    private native boolean setColorSpaceNative(long var1, int var3, boolean var4);
}

