/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdf2image;

import com.pdftools.pdf2image.BackgroundType;
import com.pdftools.pdf2image.ColorSpace;
import com.pdftools.pdf2image.ImageOptions;

public class TiffLzwImageOptions
extends ImageOptions {
    protected TiffLzwImageOptions(long handle) {
        super(handle);
    }

    public static TiffLzwImageOptions createDynamicObject(long handle) {
        return new TiffLzwImageOptions(handle);
    }

    public TiffLzwImageOptions() {
        this(TiffLzwImageOptions.newHelper());
    }

    private static long newHelper() {
        long handle = TiffLzwImageOptions.newNative();
        if (handle == 0L) {
            switch (TiffLzwImageOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            TiffLzwImageOptions.throwLastRuntimeException();
        }
        return handle;
    }

    public BackgroundType getBackground() {
        int retVal = this.getBackgroundNative(this.getHandle());
        if (retVal == 0) {
            switch (TiffLzwImageOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    TiffLzwImageOptions.throwLastRuntimeException();
                }
            }
        }
        return BackgroundType.fromValue(retVal);
    }

    public void setBackground(BackgroundType value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setBackgroundNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (TiffLzwImageOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            TiffLzwImageOptions.throwLastRuntimeException();
        }
    }

    public ColorSpace getColorSpace() {
        Integer retVal = this.getColorSpaceNative(this.getHandle());
        if (retVal == null) {
            switch (TiffLzwImageOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    TiffLzwImageOptions.throwLastRuntimeException();
                }
            }
            return null;
        }
        return ColorSpace.fromValue(retVal);
    }

    public void setColorSpace(ColorSpace value) {
        boolean retVal = this.setColorSpaceNative(this.getHandle(), value == null ? 0 : value.getValue(), value == null);
        if (!retVal) {
            switch (TiffLzwImageOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            TiffLzwImageOptions.throwLastRuntimeException();
        }
    }

    private static native long newNative();

    private native int getBackgroundNative(long var1);

    private native boolean setBackgroundNative(long var1, int var3);

    private native Integer getColorSpaceNative(long var1);

    private native boolean setColorSpaceNative(long var1, int var3, boolean var4);
}

