/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdf2image.profiles;

import com.pdftools.pdf2image.ImageOptions;
import com.pdftools.pdf2image.RenderPageAtResolution;
import com.pdftools.pdf2image.profiles.Profile;

public class Archive
extends Profile {
    protected Archive(long handle) {
        super(handle);
    }

    public static Archive createDynamicObject(long handle) {
        return new Archive(handle);
    }

    public Archive() {
        this(Archive.newHelper());
    }

    private static long newHelper() {
        long handle = Archive.newNative();
        if (handle == 0L) {
            switch (Archive.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Archive.throwLastRuntimeException();
        }
        return handle;
    }

    public ImageOptions getImageOptions() {
        long retHandle = this.getImageOptionsNative(this.getHandle());
        if (retHandle == 0L) {
            switch (Archive.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Archive.throwLastRuntimeException();
        }
        return ImageOptions.createDynamicObject(retHandle);
    }

    public void setImageOptions(ImageOptions value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setImageOptionsNative(this.getHandle(), Archive.getHandle(value), value);
        if (!retVal) {
            switch (Archive.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Archive.getLastErrorMessage());
                }
            }
            Archive.throwLastRuntimeException();
        }
    }

    public RenderPageAtResolution getImageSectionMapping() {
        long retHandle = this.getImageSectionMappingNative(this.getHandle());
        if (retHandle == 0L) {
            switch (Archive.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Archive.throwLastRuntimeException();
        }
        return RenderPageAtResolution.createDynamicObject(retHandle);
    }

    private static native long newNative();

    private native long getImageOptionsNative(long var1);

    private native boolean setImageOptionsNative(long var1, long var3, ImageOptions var5);

    private native long getImageSectionMappingNative(long var1);
}

