/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdf2image.profiles;

import com.pdftools.internal.NativeObject;
import com.pdftools.pdf2image.ContentOptions;
import com.pdftools.pdf2image.profiles.Archive;
import com.pdftools.pdf2image.profiles.Fax;
import com.pdftools.pdf2image.profiles.Viewing;

public abstract class Profile
extends NativeObject {
    protected Profile(long handle) {
        super(handle);
    }

    public static Profile createDynamicObject(long handle) {
        int type = Profile.getType(handle);
        switch (type) {
            case 1: {
                return Fax.createDynamicObject(handle);
            }
            case 2: {
                return Archive.createDynamicObject(handle);
            }
            case 3: {
                return Viewing.createDynamicObject(handle);
            }
        }
        return null;
    }

    public ContentOptions getContentOptions() {
        long retHandle = this.getContentOptionsNative(this.getHandle());
        if (retHandle == 0L) {
            switch (Profile.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Profile.throwLastRuntimeException();
        }
        return ContentOptions.createDynamicObject(retHandle);
    }

    private static native int getType(long var0);

    private native long getContentOptionsNative(long var1);
}

