/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdf2image.profiles;

import com.pdftools.pdf2image.ImageOptions;
import com.pdftools.pdf2image.ImageSectionMapping;
import com.pdftools.pdf2image.profiles.Profile;

public class Viewing
extends Profile {
    protected Viewing(long handle) {
        super(handle);
    }

    public static Viewing createDynamicObject(long handle) {
        return new Viewing(handle);
    }

    public Viewing() {
        this(Viewing.newHelper());
    }

    private static long newHelper() {
        long handle = Viewing.newNative();
        if (handle == 0L) {
            switch (Viewing.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Viewing.throwLastRuntimeException();
        }
        return handle;
    }

    public ImageOptions getImageOptions() {
        long retHandle = this.getImageOptionsNative(this.getHandle());
        if (retHandle == 0L) {
            switch (Viewing.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Viewing.throwLastRuntimeException();
        }
        return ImageOptions.createDynamicObject(retHandle);
    }

    public void setImageOptions(ImageOptions value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setImageOptionsNative(this.getHandle(), Viewing.getHandle(value), value);
        if (!retVal) {
            switch (Viewing.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Viewing.getLastErrorMessage());
                }
            }
            Viewing.throwLastRuntimeException();
        }
    }

    public ImageSectionMapping getImageSectionMapping() {
        long retHandle = this.getImageSectionMappingNative(this.getHandle());
        if (retHandle == 0L) {
            switch (Viewing.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Viewing.throwLastRuntimeException();
        }
        return ImageSectionMapping.createDynamicObject(retHandle);
    }

    public void setImageSectionMapping(ImageSectionMapping value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setImageSectionMappingNative(this.getHandle(), Viewing.getHandle(value), value);
        if (!retVal) {
            switch (Viewing.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Viewing.getLastErrorMessage());
                }
            }
            Viewing.throwLastRuntimeException();
        }
    }

    private static native long newNative();

    private native long getImageOptionsNative(long var1);

    private native boolean setImageOptionsNative(long var1, long var3, ImageOptions var5);

    private native long getImageSectionMappingNative(long var1);

    private native boolean setImageSectionMappingNative(long var1, long var3, ImageSectionMapping var5);
}

