/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdfa.conversion;

import com.pdftools.internal.NativeObject;
import com.pdftools.pdf.Conformance;

public class ConversionOptions
extends NativeObject {
    protected ConversionOptions(long handle) {
        super(handle);
    }

    public static ConversionOptions createDynamicObject(long handle) {
        return new ConversionOptions(handle);
    }

    public ConversionOptions() {
        this(ConversionOptions.newHelper());
    }

    private static long newHelper() {
        long handle = ConversionOptions.newNative();
        if (handle == 0L) {
            switch (ConversionOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            ConversionOptions.throwLastRuntimeException();
        }
        return handle;
    }

    public Conformance getConformance() {
        Integer retVal = this.getConformanceNative(this.getHandle());
        if (retVal == null) {
            switch (ConversionOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    ConversionOptions.throwLastRuntimeException();
                }
            }
            return null;
        }
        return new Conformance(retVal);
    }

    public void setConformance(Conformance value) {
        boolean retVal = this.setConformanceNative(this.getHandle(), value == null ? 0 : value.getValue(), value == null);
        if (!retVal) {
            switch (ConversionOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            ConversionOptions.throwLastRuntimeException();
        }
    }

    public boolean getCopyMetadata() {
        boolean retVal = this.getCopyMetadataNative(this.getHandle());
        if (!retVal) {
            switch (ConversionOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    ConversionOptions.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setCopyMetadata(boolean value) {
        boolean retVal = this.setCopyMetadataNative(this.getHandle(), value);
        if (!retVal) {
            switch (ConversionOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            ConversionOptions.throwLastRuntimeException();
        }
    }

    public double getImageQuality() {
        double retVal = this.getImageQualityNative(this.getHandle());
        if (retVal == -1.0) {
            switch (ConversionOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    ConversionOptions.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setImageQuality(double value) {
        boolean retVal = this.setImageQualityNative(this.getHandle(), value);
        if (!retVal) {
            switch (ConversionOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(ConversionOptions.getLastErrorMessage());
                }
            }
            ConversionOptions.throwLastRuntimeException();
        }
    }

    private static native long newNative();

    private native Integer getConformanceNative(long var1);

    private native boolean setConformanceNative(long var1, int var3, boolean var4);

    private native boolean getCopyMetadataNative(long var1);

    private native boolean setCopyMetadataNative(long var1, boolean var3);

    private native double getImageQualityNative(long var1);

    private native boolean setImageQualityNative(long var1, double var3);
}

