/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdfa.conversion;

import com.pdftools.ConformanceException;
import com.pdftools.CorruptException;
import com.pdftools.GenericException;
import com.pdftools.LicenseException;
import com.pdftools.NotFoundException;
import com.pdftools.ProcessingException;
import com.pdftools.UnsupportedFeatureException;
import com.pdftools.internal.NativeObject;
import com.pdftools.pdf.Document;
import com.pdftools.pdf.OutputOptions;
import com.pdftools.pdfa.conversion.AFRelationship;
import com.pdftools.pdfa.conversion.ConversionOptions;
import com.pdftools.pdfa.conversion.EventCategory;
import com.pdftools.pdfa.conversion.EventCode;
import com.pdftools.pdfa.conversion.EventSeverity;
import com.pdftools.pdfa.conversion.InvoiceType;
import com.pdftools.pdfa.validation.AnalysisResult;
import com.pdftools.sys.Stream;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Hashtable;

public class Converter
extends NativeObject {
    private Hashtable<ConversionEventListener, ConversionEventNativeClass> conversionEventDic = new Hashtable();

    protected Converter(long handle) {
        super(handle);
    }

    public static Converter createDynamicObject(long handle) {
        return new Converter(handle);
    }

    public void addConversionEventListener(ConversionEventListener listener) {
        if (!this.conversionEventDic.containsKey(listener)) {
            ConversionEventNativeClass eventNativeClass = new ConversionEventNativeClass(listener);
            long context = this.addConversionEventHandlerNative(this.getHandle(), eventNativeClass);
            if (context == 0L) {
                Converter.throwLastRuntimeException();
            }
            eventNativeClass.context = context;
            this.conversionEventDic.put(listener, eventNativeClass);
        }
    }

    public void removeConversionEventListener(ConversionEventListener listener) {
        if (this.conversionEventDic.containsKey(listener)) {
            if (!this.removeConversionEventHandlerNative(this.getHandle(), this.conversionEventDic.get(listener).context) && Converter.getLastErrorCode() != 5) {
                Converter.throwLastRuntimeException();
            }
            this.conversionEventDic.remove(listener);
        }
    }

    public Converter() {
        this(Converter.newHelper());
    }

    private static long newHelper() {
        long handle = Converter.newNative();
        if (handle == 0L) {
            switch (Converter.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Converter.throwLastRuntimeException();
        }
        return handle;
    }

    public void addInvoiceXml(InvoiceType invoiceType, Stream invoice) {
        if (invoiceType == null) {
            throw new IllegalArgumentException("Argument 'invoiceType' must not be null.", new NullPointerException("'invoiceType'"));
        }
        if (invoice == null) {
            throw new IllegalArgumentException("Argument 'invoice' must not be null.", new NullPointerException("'invoice'"));
        }
        this.addInvoiceXml(invoiceType, invoice, null);
    }

    public void addInvoiceXml(InvoiceType invoiceType, Stream invoice, AFRelationship afRelationship) {
        if (invoiceType == null) {
            throw new IllegalArgumentException("Argument 'invoiceType' must not be null.", new NullPointerException("'invoiceType'"));
        }
        if (invoice == null) {
            throw new IllegalArgumentException("Argument 'invoice' must not be null.", new NullPointerException("'invoice'"));
        }
        boolean retVal = this.addInvoiceXmlNative(this.getHandle(), invoiceType.getValue(), invoice, afRelationship == null ? 0 : afRelationship.getValue(), afRelationship == null);
        if (!retVal) {
            switch (Converter.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Converter.getLastErrorMessage());
                }
            }
            Converter.throwLastRuntimeException();
        }
    }

    public void addAssociatedFile(Stream embeddedFile, String name) throws IOException {
        if (embeddedFile == null) {
            throw new IllegalArgumentException("Argument 'embeddedFile' must not be null.", new NullPointerException("'embeddedFile'"));
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 'name' must not be null.", new NullPointerException("'name'"));
        }
        this.addAssociatedFile(embeddedFile, name, null, null, null, null, null);
    }

    public void addAssociatedFile(Stream embeddedFile, String name, Integer associate) throws IOException {
        if (embeddedFile == null) {
            throw new IllegalArgumentException("Argument 'embeddedFile' must not be null.", new NullPointerException("'embeddedFile'"));
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 'name' must not be null.", new NullPointerException("'name'"));
        }
        this.addAssociatedFile(embeddedFile, name, associate, null, null, null, null);
    }

    public void addAssociatedFile(Stream embeddedFile, String name, Integer associate, AFRelationship afRelationship) throws IOException {
        if (embeddedFile == null) {
            throw new IllegalArgumentException("Argument 'embeddedFile' must not be null.", new NullPointerException("'embeddedFile'"));
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 'name' must not be null.", new NullPointerException("'name'"));
        }
        this.addAssociatedFile(embeddedFile, name, associate, afRelationship, null, null, null);
    }

    public void addAssociatedFile(Stream embeddedFile, String name, Integer associate, AFRelationship afRelationship, String mimeType) throws IOException {
        if (embeddedFile == null) {
            throw new IllegalArgumentException("Argument 'embeddedFile' must not be null.", new NullPointerException("'embeddedFile'"));
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 'name' must not be null.", new NullPointerException("'name'"));
        }
        this.addAssociatedFile(embeddedFile, name, associate, afRelationship, mimeType, null, null);
    }

    public void addAssociatedFile(Stream embeddedFile, String name, Integer associate, AFRelationship afRelationship, String mimeType, String description) throws IOException {
        if (embeddedFile == null) {
            throw new IllegalArgumentException("Argument 'embeddedFile' must not be null.", new NullPointerException("'embeddedFile'"));
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 'name' must not be null.", new NullPointerException("'name'"));
        }
        this.addAssociatedFile(embeddedFile, name, associate, afRelationship, mimeType, description, null);
    }

    public void addAssociatedFile(Stream embeddedFile, String name, Integer associate, AFRelationship afRelationship, String mimeType, String description, OffsetDateTime modificationDate) throws IOException {
        if (embeddedFile == null) {
            throw new IllegalArgumentException("Argument 'embeddedFile' must not be null.", new NullPointerException("'embeddedFile'"));
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 'name' must not be null.", new NullPointerException("'name'"));
        }
        boolean retVal = this.addAssociatedFileNative(this.getHandle(), embeddedFile, name, associate, afRelationship == null ? 0 : afRelationship.getValue(), afRelationship == null, mimeType, description, modificationDate == null, modificationDate != null ? modificationDate.getYear() : 0, modificationDate != null ? modificationDate.getMonthValue() : 0, modificationDate != null ? modificationDate.getDayOfMonth() : 0, modificationDate != null ? modificationDate.getHour() : 0, modificationDate != null ? modificationDate.getMinute() : 0, modificationDate != null ? modificationDate.getSecond() : 0, modificationDate != null ? modificationDate.getOffset().getTotalSeconds() : 0);
        if (!retVal) {
            switch (Converter.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Converter.getLastErrorMessage());
                }
                case 4: {
                    throw new IOException(Converter.getLastErrorMessage());
                }
            }
            Converter.throwLastRuntimeException();
        }
    }

    public Document convert(AnalysisResult analysis, Document document, Stream outStream) throws IOException, NotFoundException, GenericException, LicenseException, CorruptException, ConformanceException, UnsupportedFeatureException, ProcessingException {
        if (analysis == null) {
            throw new IllegalArgumentException("Argument 'analysis' must not be null.", new NullPointerException("'analysis'"));
        }
        if (document == null) {
            throw new IllegalArgumentException("Argument 'document' must not be null.", new NullPointerException("'document'"));
        }
        if (outStream == null) {
            throw new IllegalArgumentException("Argument 'outStream' must not be null.", new NullPointerException("'outStream'"));
        }
        return this.convert(analysis, document, outStream, null, null);
    }

    public Document convert(AnalysisResult analysis, Document document, Stream outStream, ConversionOptions options) throws IOException, NotFoundException, GenericException, LicenseException, CorruptException, ConformanceException, UnsupportedFeatureException, ProcessingException {
        if (analysis == null) {
            throw new IllegalArgumentException("Argument 'analysis' must not be null.", new NullPointerException("'analysis'"));
        }
        if (document == null) {
            throw new IllegalArgumentException("Argument 'document' must not be null.", new NullPointerException("'document'"));
        }
        if (outStream == null) {
            throw new IllegalArgumentException("Argument 'outStream' must not be null.", new NullPointerException("'outStream'"));
        }
        return this.convert(analysis, document, outStream, options, null);
    }

    public Document convert(AnalysisResult analysis, Document document, Stream outStream, ConversionOptions options, OutputOptions outOptions) throws IOException, NotFoundException, GenericException, LicenseException, CorruptException, ConformanceException, UnsupportedFeatureException, ProcessingException {
        if (analysis == null) {
            throw new IllegalArgumentException("Argument 'analysis' must not be null.", new NullPointerException("'analysis'"));
        }
        if (document == null) {
            throw new IllegalArgumentException("Argument 'document' must not be null.", new NullPointerException("'document'"));
        }
        if (outStream == null) {
            throw new IllegalArgumentException("Argument 'outStream' must not be null.", new NullPointerException("'outStream'"));
        }
        long retHandle = this.convertNative(this.getHandle(), Converter.getHandle(analysis), analysis, Converter.getHandle(document), document, outStream, Converter.getHandle(options), options, Converter.getHandle(outOptions), outOptions);
        if (retHandle == 0L) {
            switch (Converter.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 2: {
                    throw new IllegalStateException(Converter.getLastErrorMessage());
                }
                case 3: {
                    throw new IllegalArgumentException(Converter.getLastErrorMessage());
                }
                case 4: {
                    throw new IOException(Converter.getLastErrorMessage());
                }
                case 5: {
                    throw new NotFoundException(Converter.getLastErrorMessage());
                }
                case 10: {
                    throw new GenericException(Converter.getLastErrorMessage());
                }
                case 12: {
                    throw new LicenseException(Converter.getLastErrorMessage());
                }
                case 16: {
                    throw new CorruptException(Converter.getLastErrorMessage());
                }
                case 18: {
                    throw new ConformanceException(Converter.getLastErrorMessage());
                }
                case 19: {
                    throw new UnsupportedFeatureException(Converter.getLastErrorMessage());
                }
                case 21: {
                    throw new ProcessingException(Converter.getLastErrorMessage());
                }
            }
            Converter.throwLastRuntimeException();
        }
        return Document.createDynamicObject(retHandle);
    }

    private native long addConversionEventHandlerNative(long var1, ConversionEventNativeClass var3);

    private native boolean removeConversionEventHandlerNative(long var1, long var3);

    private static native long newNative();

    private native boolean addInvoiceXmlNative(long var1, int var3, Stream var4, int var5, boolean var6);

    private native boolean addAssociatedFileNative(long var1, Stream var3, String var4, Integer var5, int var6, boolean var7, String var8, String var9, boolean var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17);

    private native long convertNative(long var1, long var3, AnalysisResult var5, long var6, Document var8, Stream var9, long var10, ConversionOptions var12, long var13, OutputOptions var15);

    private class ConversionEventNativeClass {
        private ConversionEventListener listener;
        private long context;

        public ConversionEventNativeClass(ConversionEventListener listener) {
            this.listener = listener;
        }

        public void conversionEventHandler(String dataPart, String message, EventSeverity severity, EventCategory category, EventCode code, String context, int pageNo) {
            ConversionEvent event = new ConversionEvent(this, dataPart, message, severity, category, code, context, pageNo);
            try {
                this.listener.conversionEvent(event);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface ConversionEventListener
    extends EventListener {
        public void conversionEvent(ConversionEvent var1);
    }

    public class ConversionEvent
    extends EventObject {
        private static final long serialVersionUID = 1576L;
        private String dataPart;
        private String message;
        private EventSeverity severity;
        private EventCategory category;
        private EventCode code;
        private String context;
        private int pageNo;

        private ConversionEvent(Object source, String dataPart, String message, EventSeverity severity, EventCategory category, EventCode code, String context, int pageNo) {
            super(source);
            this.dataPart = dataPart;
            this.message = message;
            this.severity = severity;
            this.category = category;
            this.code = code;
            this.context = context;
            this.pageNo = pageNo;
        }

        public String getDataPart() {
            return this.dataPart;
        }

        public String getMessage() {
            return this.message;
        }

        public EventSeverity getSeverity() {
            return this.severity;
        }

        public EventCategory getCategory() {
            return this.category;
        }

        public EventCode getCode() {
            return this.code;
        }

        public String getContext() {
            return this.context;
        }

        public int getPageNo() {
            return this.pageNo;
        }
    }
}

