/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdfa.conversion;

public enum EventCategory {
    VISUAL_DIFFERENCES(1),
    REPAIRED_CORRUPTION(2),
    MANAGED_COLORS(4),
    CHANGED_COLORANT(8),
    REMOVED_EXTERNAL_CONTENT(16),
    CONVERTED_FONT(32),
    SUBSTITUTED_FONT(64),
    REMOVED_TRANSPARENCY(128),
    REMOVED_ANNOTATION(256),
    REMOVED_MULTIMEDIA(512),
    REMOVED_ACTION(1024),
    REMOVED_METADATA(2048),
    REMOVED_STRUCTURE(4096),
    REMOVED_OPTIONAL_CONTENT(8192),
    CONVERTED_EMBEDDED_FILE(16384),
    REMOVED_EMBEDDED_FILE(32768),
    REMOVED_SIGNATURE(65536);

    private int value;

    private EventCategory(int value) {
        this.value = value;
    }

    public static EventCategory fromValue(int value) {
        switch (value) {
            case 1: {
                return VISUAL_DIFFERENCES;
            }
            case 2: {
                return REPAIRED_CORRUPTION;
            }
            case 4: {
                return MANAGED_COLORS;
            }
            case 8: {
                return CHANGED_COLORANT;
            }
            case 16: {
                return REMOVED_EXTERNAL_CONTENT;
            }
            case 32: {
                return CONVERTED_FONT;
            }
            case 64: {
                return SUBSTITUTED_FONT;
            }
            case 128: {
                return REMOVED_TRANSPARENCY;
            }
            case 256: {
                return REMOVED_ANNOTATION;
            }
            case 512: {
                return REMOVED_MULTIMEDIA;
            }
            case 1024: {
                return REMOVED_ACTION;
            }
            case 2048: {
                return REMOVED_METADATA;
            }
            case 4096: {
                return REMOVED_STRUCTURE;
            }
            case 8192: {
                return REMOVED_OPTIONAL_CONTENT;
            }
            case 16384: {
                return CONVERTED_EMBEDDED_FILE;
            }
            case 32768: {
                return REMOVED_EMBEDDED_FILE;
            }
            case 65536: {
                return REMOVED_SIGNATURE;
            }
        }
        throw new IllegalArgumentException("Unknown value for EventCategory: " + value);
    }

    public int getValue() {
        return this.value;
    }
}

