/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdfa.conversion;

public enum EventCode {
    GENERIC(1),
    REMOVED_XFA(0x1000000),
    FONT_NON_EMBEDDED_ORDERING_IDENTITY(0x1000001),
    FONT_NO_ROTATE(0x1000002),
    FONT_NO_ITALIC_SIMULATION(0x1000003),
    CLIPPED_NUMBER_VALUE(0x1000004),
    RECOVERED_IMAGE_SIZE(0x2000000),
    REPAIRED_FONT(0x2000001),
    COPIED_OUTPUT_INTENT(0x3000000),
    SET_OUTPUT_INTENT(0x3000001),
    GENERATED_OUTPUT_INTENT(0x3000002),
    SET_COLOR_PROFILE(0x3000003),
    GENERATED_COLOR_PROFILE(0x3000004),
    CREATED_CALIBRATED(0x3000005),
    RENAMED_COLORANT(0x4000000),
    RESOLVED_COLORANT_COLLISION(0x4000001),
    EMBEDED_FONT(0x6000000),
    SUBSTITUTED_FONT(0x7000000),
    SUBSTITUTED_MULTIPLE_MASTER(0x7000001),
    CONVERTED_TO_STAMP(0x9000000),
    REMOVED_DOCUMENT_METADATA(0xC000000),
    COPIED_EMBEDDED_FILE(0xF000000),
    CONVERTING_EMBEDDED_FILE_START(0xF000001),
    CONVERTING_EMBEDDED_FILE_SUCCESS(0xF000002),
    CHANGED_TO_INITIAL_DOCUMENT(0x10000000),
    CONVERTING_EMBEDDED_FILE_ERROR(0x10000001),
    REMOVED_EMBEDDED_FILE(0x10000002),
    REMOVED_FILE_ATTACHMENT_ANNOTATION(0x10000003);

    private int value;

    private EventCode(int value) {
        this.value = value;
    }

    public static EventCode fromValue(int value) {
        switch (value) {
            case 1: {
                return GENERIC;
            }
            case 0x1000000: {
                return REMOVED_XFA;
            }
            case 0x1000001: {
                return FONT_NON_EMBEDDED_ORDERING_IDENTITY;
            }
            case 0x1000002: {
                return FONT_NO_ROTATE;
            }
            case 0x1000003: {
                return FONT_NO_ITALIC_SIMULATION;
            }
            case 0x1000004: {
                return CLIPPED_NUMBER_VALUE;
            }
            case 0x2000000: {
                return RECOVERED_IMAGE_SIZE;
            }
            case 0x2000001: {
                return REPAIRED_FONT;
            }
            case 0x3000000: {
                return COPIED_OUTPUT_INTENT;
            }
            case 0x3000001: {
                return SET_OUTPUT_INTENT;
            }
            case 0x3000002: {
                return GENERATED_OUTPUT_INTENT;
            }
            case 0x3000003: {
                return SET_COLOR_PROFILE;
            }
            case 0x3000004: {
                return GENERATED_COLOR_PROFILE;
            }
            case 0x3000005: {
                return CREATED_CALIBRATED;
            }
            case 0x4000000: {
                return RENAMED_COLORANT;
            }
            case 0x4000001: {
                return RESOLVED_COLORANT_COLLISION;
            }
            case 0x6000000: {
                return EMBEDED_FONT;
            }
            case 0x7000000: {
                return SUBSTITUTED_FONT;
            }
            case 0x7000001: {
                return SUBSTITUTED_MULTIPLE_MASTER;
            }
            case 0x9000000: {
                return CONVERTED_TO_STAMP;
            }
            case 0xC000000: {
                return REMOVED_DOCUMENT_METADATA;
            }
            case 0xF000000: {
                return COPIED_EMBEDDED_FILE;
            }
            case 0xF000001: {
                return CONVERTING_EMBEDDED_FILE_START;
            }
            case 0xF000002: {
                return CONVERTING_EMBEDDED_FILE_SUCCESS;
            }
            case 0x10000000: {
                return CHANGED_TO_INITIAL_DOCUMENT;
            }
            case 0x10000001: {
                return CONVERTING_EMBEDDED_FILE_ERROR;
            }
            case 0x10000002: {
                return REMOVED_EMBEDDED_FILE;
            }
            case 0x10000003: {
                return REMOVED_FILE_ATTACHMENT_ANNOTATION;
            }
        }
        throw new IllegalArgumentException("Unknown value for EventCode: " + value);
    }

    public int getValue() {
        return this.value;
    }
}

