/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdfa.validation;

import com.pdftools.internal.NativeObject;
import com.pdftools.pdf.Conformance;

public class AnalysisOptions
extends NativeObject {
    protected AnalysisOptions(long handle) {
        super(handle);
    }

    public static AnalysisOptions createDynamicObject(long handle) {
        return new AnalysisOptions(handle);
    }

    public AnalysisOptions() {
        this(AnalysisOptions.newHelper());
    }

    private static long newHelper() {
        long handle = AnalysisOptions.newNative();
        if (handle == 0L) {
            switch (AnalysisOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            AnalysisOptions.throwLastRuntimeException();
        }
        return handle;
    }

    public Conformance getConformance() {
        int retVal = this.getConformanceNative(this.getHandle());
        if (retVal == 0) {
            switch (AnalysisOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    AnalysisOptions.throwLastRuntimeException();
                }
            }
        }
        return new Conformance(retVal);
    }

    public void setConformance(Conformance value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setConformanceNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (AnalysisOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            AnalysisOptions.throwLastRuntimeException();
        }
    }

    public boolean getStrictMode() {
        boolean retVal = this.getStrictModeNative(this.getHandle());
        if (!retVal) {
            switch (AnalysisOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    AnalysisOptions.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setStrictMode(boolean value) {
        boolean retVal = this.setStrictModeNative(this.getHandle(), value);
        if (!retVal) {
            switch (AnalysisOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            AnalysisOptions.throwLastRuntimeException();
        }
    }

    private static native long newNative();

    private native int getConformanceNative(long var1);

    private native boolean setConformanceNative(long var1, int var3);

    private native boolean getStrictModeNative(long var1);

    private native boolean setStrictModeNative(long var1, boolean var3);
}

