/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdfa.validation;

public enum ErrorCategory {
    FORMAT(1),
    PDF(2),
    ENCRYPTION(4),
    COLOR(8),
    RENDERING(16),
    ALTERNATE(32),
    POST_SCRIPT(64),
    EXTERNAL(128),
    FONT(256),
    UNICODE(512),
    TRANSPARENCY(1024),
    UNSUPPORTED_ANNOTATION(2048),
    MULTIMEDIA(4096),
    PRINT(8192),
    APPEARANCE(16384),
    ACTION(32768),
    METADATA(65536),
    STRUCTURE(131072),
    OPTIONAL_CONTENT(262144),
    EMBEDDED_FILE(524288),
    SIGNATURE(0x100000),
    CUSTOM(0x40000000);

    private int value;

    private ErrorCategory(int value) {
        this.value = value;
    }

    public static ErrorCategory fromValue(int value) {
        switch (value) {
            case 1: {
                return FORMAT;
            }
            case 2: {
                return PDF;
            }
            case 4: {
                return ENCRYPTION;
            }
            case 8: {
                return COLOR;
            }
            case 16: {
                return RENDERING;
            }
            case 32: {
                return ALTERNATE;
            }
            case 64: {
                return POST_SCRIPT;
            }
            case 128: {
                return EXTERNAL;
            }
            case 256: {
                return FONT;
            }
            case 512: {
                return UNICODE;
            }
            case 1024: {
                return TRANSPARENCY;
            }
            case 2048: {
                return UNSUPPORTED_ANNOTATION;
            }
            case 4096: {
                return MULTIMEDIA;
            }
            case 8192: {
                return PRINT;
            }
            case 16384: {
                return APPEARANCE;
            }
            case 32768: {
                return ACTION;
            }
            case 65536: {
                return METADATA;
            }
            case 131072: {
                return STRUCTURE;
            }
            case 262144: {
                return OPTIONAL_CONTENT;
            }
            case 524288: {
                return EMBEDDED_FILE;
            }
            case 0x100000: {
                return SIGNATURE;
            }
            case 0x40000000: {
                return CUSTOM;
            }
        }
        throw new IllegalArgumentException("Unknown value for ErrorCategory: " + value);
    }

    public int getValue() {
        return this.value;
    }
}

