/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.pdfa.validation;

import com.pdftools.LicenseException;
import com.pdftools.ProcessingException;
import com.pdftools.internal.NativeObject;
import com.pdftools.pdf.Document;
import com.pdftools.pdfa.validation.AnalysisOptions;
import com.pdftools.pdfa.validation.AnalysisResult;
import com.pdftools.pdfa.validation.ErrorCategory;
import com.pdftools.pdfa.validation.ValidationOptions;
import com.pdftools.pdfa.validation.ValidationResult;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Hashtable;

public class Validator
extends NativeObject {
    private Hashtable<ErrorListener, ErrorNativeClass> errorDic = new Hashtable();

    protected Validator(long handle) {
        super(handle);
    }

    public static Validator createDynamicObject(long handle) {
        return new Validator(handle);
    }

    public void addErrorListener(ErrorListener listener) {
        if (!this.errorDic.containsKey(listener)) {
            ErrorNativeClass eventNativeClass = new ErrorNativeClass(listener);
            long context = this.addErrorHandlerNative(this.getHandle(), eventNativeClass);
            if (context == 0L) {
                Validator.throwLastRuntimeException();
            }
            eventNativeClass.context = context;
            this.errorDic.put(listener, eventNativeClass);
        }
    }

    public void removeErrorListener(ErrorListener listener) {
        if (this.errorDic.containsKey(listener)) {
            if (!this.removeErrorHandlerNative(this.getHandle(), this.errorDic.get(listener).context) && Validator.getLastErrorCode() != 5) {
                Validator.throwLastRuntimeException();
            }
            this.errorDic.remove(listener);
        }
    }

    public Validator() {
        this(Validator.newHelper());
    }

    private static long newHelper() {
        long handle = Validator.newNative();
        if (handle == 0L) {
            switch (Validator.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Validator.throwLastRuntimeException();
        }
        return handle;
    }

    public ValidationResult validate(Document document) throws LicenseException, ProcessingException {
        if (document == null) {
            throw new IllegalArgumentException("Argument 'document' must not be null.", new NullPointerException("'document'"));
        }
        return this.validate(document, null);
    }

    public ValidationResult validate(Document document, ValidationOptions options) throws LicenseException, ProcessingException {
        if (document == null) {
            throw new IllegalArgumentException("Argument 'document' must not be null.", new NullPointerException("'document'"));
        }
        long retHandle = this.validateNative(this.getHandle(), Validator.getHandle(document), document, Validator.getHandle(options), options);
        if (retHandle == 0L) {
            switch (Validator.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 12: {
                    throw new LicenseException(Validator.getLastErrorMessage());
                }
                case 21: {
                    throw new ProcessingException(Validator.getLastErrorMessage());
                }
            }
            Validator.throwLastRuntimeException();
        }
        return ValidationResult.createDynamicObject(retHandle);
    }

    public AnalysisResult analyze(Document document) throws LicenseException {
        if (document == null) {
            throw new IllegalArgumentException("Argument 'document' must not be null.", new NullPointerException("'document'"));
        }
        return this.analyze(document, null);
    }

    public AnalysisResult analyze(Document document, AnalysisOptions options) throws LicenseException {
        if (document == null) {
            throw new IllegalArgumentException("Argument 'document' must not be null.", new NullPointerException("'document'"));
        }
        long retHandle = this.analyzeNative(this.getHandle(), Validator.getHandle(document), document, Validator.getHandle(options), options);
        if (retHandle == 0L) {
            switch (Validator.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Validator.getLastErrorMessage());
                }
                case 12: {
                    throw new LicenseException(Validator.getLastErrorMessage());
                }
            }
            Validator.throwLastRuntimeException();
        }
        return AnalysisResult.createDynamicObject(retHandle);
    }

    private native long addErrorHandlerNative(long var1, ErrorNativeClass var3);

    private native boolean removeErrorHandlerNative(long var1, long var3);

    private static native long newNative();

    private native long validateNative(long var1, long var3, Document var5, long var6, ValidationOptions var8);

    private native long analyzeNative(long var1, long var3, Document var5, long var6, AnalysisOptions var8);

    private class ErrorNativeClass {
        private ErrorListener listener;
        private long context;

        public ErrorNativeClass(ErrorListener listener) {
            this.listener = listener;
        }

        public void errorHandler(String dataPart, String message, ErrorCategory category, String context, int pageNo, int objectNo) {
            Error event = new Error(this, dataPart, message, category, context, pageNo, objectNo);
            try {
                this.listener.error(event);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface ErrorListener
    extends EventListener {
        public void error(Error var1);
    }

    public class Error
    extends EventObject {
        private static final long serialVersionUID = 522L;
        private String dataPart;
        private String message;
        private ErrorCategory category;
        private String context;
        private int pageNo;
        private int objectNo;

        private Error(Object source, String dataPart, String message, ErrorCategory category, String context, int pageNo, int objectNo) {
            super(source);
            this.dataPart = dataPart;
            this.message = message;
            this.category = category;
            this.context = context;
            this.pageNo = pageNo;
            this.objectNo = objectNo;
        }

        public String getDataPart() {
            return this.dataPart;
        }

        public String getMessage() {
            return this.message;
        }

        public ErrorCategory getCategory() {
            return this.category;
        }

        public String getContext() {
            return this.context;
        }

        public int getPageNo() {
            return this.pageNo;
        }

        public int getObjectNo() {
            return this.objectNo;
        }
    }
}

