/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.sign;

import com.pdftools.CorruptException;
import com.pdftools.GenericException;
import com.pdftools.NotFoundException;
import com.pdftools.ProcessingException;
import com.pdftools.geometry.units.Length;
import com.pdftools.geometry.units.Size;
import com.pdftools.internal.NativeObject;
import com.pdftools.sign.CustomTextVariableMap;
import com.pdftools.sys.Stream;

public class Appearance
extends NativeObject {
    protected Appearance(long handle) {
        super(handle);
    }

    public static Appearance createDynamicObject(long handle) {
        return new Appearance(handle);
    }

    public static Appearance createFromJson(Stream stream) throws NotFoundException, GenericException, CorruptException, ProcessingException {
        if (stream == null) {
            throw new IllegalArgumentException("Argument 'stream' must not be null.", new NullPointerException("'stream'"));
        }
        long retHandle = Appearance.createFromJsonNative(stream);
        if (retHandle == 0L) {
            switch (Appearance.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 5: {
                    throw new NotFoundException(Appearance.getLastErrorMessage());
                }
                case 10: {
                    throw new GenericException(Appearance.getLastErrorMessage());
                }
                case 16: {
                    throw new CorruptException(Appearance.getLastErrorMessage());
                }
                case 21: {
                    throw new ProcessingException(Appearance.getLastErrorMessage());
                }
            }
            Appearance.throwLastRuntimeException();
        }
        return Appearance.createDynamicObject(retHandle);
    }

    public static Appearance createFromXml(Stream stream) throws NotFoundException, GenericException, CorruptException, ProcessingException {
        if (stream == null) {
            throw new IllegalArgumentException("Argument 'stream' must not be null.", new NullPointerException("'stream'"));
        }
        long retHandle = Appearance.createFromXmlNative(stream);
        if (retHandle == 0L) {
            switch (Appearance.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 5: {
                    throw new NotFoundException(Appearance.getLastErrorMessage());
                }
                case 10: {
                    throw new GenericException(Appearance.getLastErrorMessage());
                }
                case 16: {
                    throw new CorruptException(Appearance.getLastErrorMessage());
                }
                case 21: {
                    throw new ProcessingException(Appearance.getLastErrorMessage());
                }
            }
            Appearance.throwLastRuntimeException();
        }
        return Appearance.createDynamicObject(retHandle);
    }

    public static Appearance createFieldBoundingBox(Size size) {
        if (size == null) {
            throw new IllegalArgumentException("Argument 'size' must not be null.", new NullPointerException("'size'"));
        }
        long retHandle = Appearance.createFieldBoundingBoxNative(size.getWidthValue(), size.getHeightValue());
        if (retHandle == 0L) {
            switch (Appearance.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Appearance.throwLastRuntimeException();
        }
        return Appearance.createDynamicObject(retHandle);
    }

    public Integer getPageNumber() {
        Integer retVal = this.getPageNumberNative(this.getHandle());
        if (retVal == null) {
            switch (Appearance.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Appearance.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setPageNumber(Integer value) {
        boolean retVal = this.setPageNumberNative(this.getHandle(), value);
        if (!retVal) {
            switch (Appearance.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Appearance.throwLastRuntimeException();
        }
    }

    public Length getTop() {
        Double retVal = this.getTopNative(this.getHandle());
        if (retVal == null) {
            switch (Appearance.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Appearance.throwLastRuntimeException();
                }
            }
            return null;
        }
        return new Length(retVal);
    }

    public void setTop(Length value) {
        boolean retVal = this.setTopNative(this.getHandle(), value != null ? Double.valueOf(value.getValue()) : null);
        if (!retVal) {
            switch (Appearance.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Appearance.getLastErrorMessage());
                }
            }
            Appearance.throwLastRuntimeException();
        }
    }

    public Length getRight() {
        Double retVal = this.getRightNative(this.getHandle());
        if (retVal == null) {
            switch (Appearance.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Appearance.throwLastRuntimeException();
                }
            }
            return null;
        }
        return new Length(retVal);
    }

    public void setRight(Length value) {
        boolean retVal = this.setRightNative(this.getHandle(), value != null ? Double.valueOf(value.getValue()) : null);
        if (!retVal) {
            switch (Appearance.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Appearance.getLastErrorMessage());
                }
            }
            Appearance.throwLastRuntimeException();
        }
    }

    public Length getBottom() {
        Double retVal = this.getBottomNative(this.getHandle());
        if (retVal == null) {
            switch (Appearance.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Appearance.throwLastRuntimeException();
                }
            }
            return null;
        }
        return new Length(retVal);
    }

    public void setBottom(Length value) {
        boolean retVal = this.setBottomNative(this.getHandle(), value != null ? Double.valueOf(value.getValue()) : null);
        if (!retVal) {
            switch (Appearance.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Appearance.getLastErrorMessage());
                }
            }
            Appearance.throwLastRuntimeException();
        }
    }

    public Length getLeft() {
        Double retVal = this.getLeftNative(this.getHandle());
        if (retVal == null) {
            switch (Appearance.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Appearance.throwLastRuntimeException();
                }
            }
            return null;
        }
        return new Length(retVal);
    }

    public void setLeft(Length value) {
        boolean retVal = this.setLeftNative(this.getHandle(), value != null ? Double.valueOf(value.getValue()) : null);
        if (!retVal) {
            switch (Appearance.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Appearance.getLastErrorMessage());
                }
            }
            Appearance.throwLastRuntimeException();
        }
    }

    public CustomTextVariableMap getCustomTextVariables() {
        long retHandle = this.getCustomTextVariablesNative(this.getHandle());
        if (retHandle == 0L) {
            switch (Appearance.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Appearance.throwLastRuntimeException();
        }
        return CustomTextVariableMap.createDynamicObject(retHandle);
    }

    private static native long createFromJsonNative(Stream var0);

    private static native long createFromXmlNative(Stream var0);

    private static native long createFieldBoundingBoxNative(double var0, double var2);

    private native Integer getPageNumberNative(long var1);

    private native boolean setPageNumberNative(long var1, Integer var3);

    private native Double getTopNative(long var1);

    private native boolean setTopNative(long var1, Double var3);

    private native Double getRightNative(long var1);

    private native boolean setRightNative(long var1, Double var3);

    private native Double getBottomNative(long var1);

    private native boolean setBottomNative(long var1, Double var3);

    private native Double getLeftNative(long var1);

    private native boolean setLeftNative(long var1, Double var3);

    private native long getCustomTextVariablesNative(long var1);
}

