/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.sign;

import com.pdftools.internal.NativeObject;
import com.pdftools.pdf.MdpPermissions;

public class MdpPermissionOptions
extends NativeObject {
    protected MdpPermissionOptions(long handle) {
        super(handle);
    }

    public static MdpPermissionOptions createDynamicObject(long handle) {
        return new MdpPermissionOptions(handle);
    }

    public MdpPermissionOptions(MdpPermissions permissions) {
        this(MdpPermissionOptions.newHelper(permissions));
    }

    private static long newHelper(MdpPermissions permissions) {
        if (permissions == null) {
            throw new IllegalArgumentException("Argument 'permissions' must not be null.", new NullPointerException("'permissions'"));
        }
        long handle = MdpPermissionOptions.newNative(permissions.getValue());
        if (handle == 0L) {
            switch (MdpPermissionOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            MdpPermissionOptions.throwLastRuntimeException();
        }
        return handle;
    }

    public MdpPermissions getPermissions() {
        int retVal = this.getPermissionsNative(this.getHandle());
        if (retVal == 0) {
            switch (MdpPermissionOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    MdpPermissionOptions.throwLastRuntimeException();
                }
            }
        }
        return MdpPermissions.fromValue(retVal);
    }

    public void setPermissions(MdpPermissions value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setPermissionsNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (MdpPermissionOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            MdpPermissionOptions.throwLastRuntimeException();
        }
    }

    private static native long newNative(int var0);

    private native int getPermissionsNative(long var1);

    private native boolean setPermissionsNative(long var1, int var3);
}

