/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.sign;

import com.pdftools.sign.AddValidationInformation;
import com.pdftools.sign.SignatureRemoval;

public class OutputOptions
extends com.pdftools.pdf.OutputOptions {
    protected OutputOptions(long handle) {
        super(handle);
    }

    public static OutputOptions createDynamicObject(long handle) {
        return new OutputOptions(handle);
    }

    public OutputOptions() {
        this(OutputOptions.newHelper());
    }

    private static long newHelper() {
        long handle = OutputOptions.newNative();
        if (handle == 0L) {
            switch (OutputOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            OutputOptions.throwLastRuntimeException();
        }
        return handle;
    }

    public SignatureRemoval getRemoveSignatures() {
        int retVal = this.getRemoveSignaturesNative(this.getHandle());
        if (retVal == 0) {
            switch (OutputOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    OutputOptions.throwLastRuntimeException();
                }
            }
        }
        return SignatureRemoval.fromValue(retVal);
    }

    public void setRemoveSignatures(SignatureRemoval value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setRemoveSignaturesNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (OutputOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            OutputOptions.throwLastRuntimeException();
        }
    }

    public AddValidationInformation getAddValidationInformation() {
        int retVal = this.getAddValidationInformationNative(this.getHandle());
        if (retVal == 0) {
            switch (OutputOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    OutputOptions.throwLastRuntimeException();
                }
            }
        }
        return AddValidationInformation.fromValue(retVal);
    }

    public void setAddValidationInformation(AddValidationInformation value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setAddValidationInformationNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (OutputOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            OutputOptions.throwLastRuntimeException();
        }
    }

    private static native long newNative();

    private native int getRemoveSignaturesNative(long var1);

    private native boolean setRemoveSignaturesNative(long var1, int var3);

    private native int getAddValidationInformationNative(long var1);

    private native boolean setAddValidationInformationNative(long var1, int var3);
}

