/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.sign;

import com.pdftools.ExistsException;
import com.pdftools.HttpException;
import com.pdftools.LicenseException;
import com.pdftools.NotFoundException;
import com.pdftools.PermissionException;
import com.pdftools.RetryException;
import com.pdftools.UnsupportedFeatureException;
import com.pdftools.crypto.providers.Provider;
import com.pdftools.internal.NativeObject;
import com.pdftools.pdf.Document;
import com.pdftools.sign.MdpPermissionOptions;
import com.pdftools.sign.OutputOptions;
import com.pdftools.sign.PreparedDocument;
import com.pdftools.sign.SignatureConfiguration;
import com.pdftools.sign.SignatureFieldOptions;
import com.pdftools.sign.TimestampConfiguration;
import com.pdftools.sign.WarningCategory;
import com.pdftools.sys.Stream;
import java.io.IOException;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Hashtable;

public class Signer
extends NativeObject {
    private Hashtable<WarningListener, WarningNativeClass> warningDic = new Hashtable();

    protected Signer(long handle) {
        super(handle);
    }

    public static Signer createDynamicObject(long handle) {
        return new Signer(handle);
    }

    public void addWarningListener(WarningListener listener) {
        if (!this.warningDic.containsKey(listener)) {
            WarningNativeClass eventNativeClass = new WarningNativeClass(listener);
            long context = this.addWarningHandlerNative(this.getHandle(), eventNativeClass);
            if (context == 0L) {
                Signer.throwLastRuntimeException();
            }
            eventNativeClass.context = context;
            this.warningDic.put(listener, eventNativeClass);
        }
    }

    public void removeWarningListener(WarningListener listener) {
        if (this.warningDic.containsKey(listener)) {
            if (!this.removeWarningHandlerNative(this.getHandle(), this.warningDic.get(listener).context) && Signer.getLastErrorCode() != 5) {
                Signer.throwLastRuntimeException();
            }
            this.warningDic.remove(listener);
        }
    }

    public Signer() {
        this(Signer.newHelper());
    }

    private static long newHelper() {
        long handle = Signer.newNative();
        if (handle == 0L) {
            switch (Signer.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Signer.throwLastRuntimeException();
        }
        return handle;
    }

    public Document sign(Document document, SignatureConfiguration configuration, Stream stream) throws IOException, NotFoundException, LicenseException, UnsupportedFeatureException, PermissionException, HttpException, RetryException {
        if (document == null) {
            throw new IllegalArgumentException("Argument 'document' must not be null.", new NullPointerException("'document'"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 'configuration' must not be null.", new NullPointerException("'configuration'"));
        }
        if (stream == null) {
            throw new IllegalArgumentException("Argument 'stream' must not be null.", new NullPointerException("'stream'"));
        }
        return this.sign(document, configuration, stream, null);
    }

    public Document sign(Document document, SignatureConfiguration configuration, Stream stream, OutputOptions outputOptions) throws IOException, NotFoundException, LicenseException, UnsupportedFeatureException, PermissionException, HttpException, RetryException {
        if (document == null) {
            throw new IllegalArgumentException("Argument 'document' must not be null.", new NullPointerException("'document'"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 'configuration' must not be null.", new NullPointerException("'configuration'"));
        }
        if (stream == null) {
            throw new IllegalArgumentException("Argument 'stream' must not be null.", new NullPointerException("'stream'"));
        }
        long retHandle = this.signNative(this.getHandle(), Signer.getHandle(document), document, Signer.getHandle(configuration), configuration, stream, Signer.getHandle(outputOptions), outputOptions);
        if (retHandle == 0L) {
            switch (Signer.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Signer.getLastErrorMessage());
                }
                case 4: {
                    throw new IOException(Signer.getLastErrorMessage());
                }
                case 5: {
                    throw new NotFoundException(Signer.getLastErrorMessage());
                }
                case 12: {
                    throw new LicenseException(Signer.getLastErrorMessage());
                }
                case 19: {
                    throw new UnsupportedFeatureException(Signer.getLastErrorMessage());
                }
                case 23: {
                    throw new PermissionException(Signer.getLastErrorMessage());
                }
                case 24: {
                    throw new HttpException(Signer.getLastErrorMessage());
                }
                case 25: {
                    throw new RetryException(Signer.getLastErrorMessage());
                }
            }
            Signer.throwLastRuntimeException();
        }
        return Document.createDynamicObject(retHandle);
    }

    public Document certify(Document document, SignatureConfiguration configuration, Stream stream) throws IOException, NotFoundException, LicenseException, UnsupportedFeatureException, PermissionException, HttpException, RetryException {
        if (document == null) {
            throw new IllegalArgumentException("Argument 'document' must not be null.", new NullPointerException("'document'"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 'configuration' must not be null.", new NullPointerException("'configuration'"));
        }
        if (stream == null) {
            throw new IllegalArgumentException("Argument 'stream' must not be null.", new NullPointerException("'stream'"));
        }
        return this.certify(document, configuration, stream, null, null);
    }

    public Document certify(Document document, SignatureConfiguration configuration, Stream stream, MdpPermissionOptions permissions) throws IOException, NotFoundException, LicenseException, UnsupportedFeatureException, PermissionException, HttpException, RetryException {
        if (document == null) {
            throw new IllegalArgumentException("Argument 'document' must not be null.", new NullPointerException("'document'"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 'configuration' must not be null.", new NullPointerException("'configuration'"));
        }
        if (stream == null) {
            throw new IllegalArgumentException("Argument 'stream' must not be null.", new NullPointerException("'stream'"));
        }
        return this.certify(document, configuration, stream, permissions, null);
    }

    public Document certify(Document document, SignatureConfiguration configuration, Stream stream, MdpPermissionOptions permissions, OutputOptions outputOptions) throws IOException, NotFoundException, LicenseException, UnsupportedFeatureException, PermissionException, HttpException, RetryException {
        if (document == null) {
            throw new IllegalArgumentException("Argument 'document' must not be null.", new NullPointerException("'document'"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 'configuration' must not be null.", new NullPointerException("'configuration'"));
        }
        if (stream == null) {
            throw new IllegalArgumentException("Argument 'stream' must not be null.", new NullPointerException("'stream'"));
        }
        long retHandle = this.certifyNative(this.getHandle(), Signer.getHandle(document), document, Signer.getHandle(configuration), configuration, stream, Signer.getHandle(permissions), permissions, Signer.getHandle(outputOptions), outputOptions);
        if (retHandle == 0L) {
            switch (Signer.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Signer.getLastErrorMessage());
                }
                case 4: {
                    throw new IOException(Signer.getLastErrorMessage());
                }
                case 5: {
                    throw new NotFoundException(Signer.getLastErrorMessage());
                }
                case 12: {
                    throw new LicenseException(Signer.getLastErrorMessage());
                }
                case 19: {
                    throw new UnsupportedFeatureException(Signer.getLastErrorMessage());
                }
                case 23: {
                    throw new PermissionException(Signer.getLastErrorMessage());
                }
                case 24: {
                    throw new HttpException(Signer.getLastErrorMessage());
                }
                case 25: {
                    throw new RetryException(Signer.getLastErrorMessage());
                }
            }
            Signer.throwLastRuntimeException();
        }
        return Document.createDynamicObject(retHandle);
    }

    public Document addTimestamp(Document document, TimestampConfiguration configuration, Stream stream) throws IOException, NotFoundException, LicenseException, UnsupportedFeatureException, PermissionException, HttpException, RetryException {
        if (document == null) {
            throw new IllegalArgumentException("Argument 'document' must not be null.", new NullPointerException("'document'"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 'configuration' must not be null.", new NullPointerException("'configuration'"));
        }
        if (stream == null) {
            throw new IllegalArgumentException("Argument 'stream' must not be null.", new NullPointerException("'stream'"));
        }
        return this.addTimestamp(document, configuration, stream, null);
    }

    public Document addTimestamp(Document document, TimestampConfiguration configuration, Stream stream, OutputOptions outputOptions) throws IOException, NotFoundException, LicenseException, UnsupportedFeatureException, PermissionException, HttpException, RetryException {
        if (document == null) {
            throw new IllegalArgumentException("Argument 'document' must not be null.", new NullPointerException("'document'"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 'configuration' must not be null.", new NullPointerException("'configuration'"));
        }
        if (stream == null) {
            throw new IllegalArgumentException("Argument 'stream' must not be null.", new NullPointerException("'stream'"));
        }
        long retHandle = this.addTimestampNative(this.getHandle(), Signer.getHandle(document), document, Signer.getHandle(configuration), configuration, stream, Signer.getHandle(outputOptions), outputOptions);
        if (retHandle == 0L) {
            switch (Signer.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Signer.getLastErrorMessage());
                }
                case 4: {
                    throw new IOException(Signer.getLastErrorMessage());
                }
                case 5: {
                    throw new NotFoundException(Signer.getLastErrorMessage());
                }
                case 12: {
                    throw new LicenseException(Signer.getLastErrorMessage());
                }
                case 19: {
                    throw new UnsupportedFeatureException(Signer.getLastErrorMessage());
                }
                case 23: {
                    throw new PermissionException(Signer.getLastErrorMessage());
                }
                case 24: {
                    throw new HttpException(Signer.getLastErrorMessage());
                }
                case 25: {
                    throw new RetryException(Signer.getLastErrorMessage());
                }
            }
            Signer.throwLastRuntimeException();
        }
        return Document.createDynamicObject(retHandle);
    }

    public Document addSignatureField(Document document, SignatureFieldOptions options, Stream stream) throws IOException, LicenseException, UnsupportedFeatureException, ExistsException {
        if (document == null) {
            throw new IllegalArgumentException("Argument 'document' must not be null.", new NullPointerException("'document'"));
        }
        if (options == null) {
            throw new IllegalArgumentException("Argument 'options' must not be null.", new NullPointerException("'options'"));
        }
        if (stream == null) {
            throw new IllegalArgumentException("Argument 'stream' must not be null.", new NullPointerException("'stream'"));
        }
        return this.addSignatureField(document, options, stream, null);
    }

    public Document addSignatureField(Document document, SignatureFieldOptions options, Stream stream, OutputOptions outputOptions) throws IOException, LicenseException, UnsupportedFeatureException, ExistsException {
        if (document == null) {
            throw new IllegalArgumentException("Argument 'document' must not be null.", new NullPointerException("'document'"));
        }
        if (options == null) {
            throw new IllegalArgumentException("Argument 'options' must not be null.", new NullPointerException("'options'"));
        }
        if (stream == null) {
            throw new IllegalArgumentException("Argument 'stream' must not be null.", new NullPointerException("'stream'"));
        }
        long retHandle = this.addSignatureFieldNative(this.getHandle(), Signer.getHandle(document), document, Signer.getHandle(options), options, stream, Signer.getHandle(outputOptions), outputOptions);
        if (retHandle == 0L) {
            switch (Signer.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 4: {
                    throw new IOException(Signer.getLastErrorMessage());
                }
                case 12: {
                    throw new LicenseException(Signer.getLastErrorMessage());
                }
                case 19: {
                    throw new UnsupportedFeatureException(Signer.getLastErrorMessage());
                }
                case 22: {
                    throw new ExistsException(Signer.getLastErrorMessage());
                }
            }
            Signer.throwLastRuntimeException();
        }
        return Document.createDynamicObject(retHandle);
    }

    public PreparedDocument addPreparedSignature(Document document, SignatureConfiguration configuration, Stream stream) throws IOException, NotFoundException, LicenseException, UnsupportedFeatureException, HttpException {
        if (document == null) {
            throw new IllegalArgumentException("Argument 'document' must not be null.", new NullPointerException("'document'"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 'configuration' must not be null.", new NullPointerException("'configuration'"));
        }
        if (stream == null) {
            throw new IllegalArgumentException("Argument 'stream' must not be null.", new NullPointerException("'stream'"));
        }
        return this.addPreparedSignature(document, configuration, stream, null);
    }

    public PreparedDocument addPreparedSignature(Document document, SignatureConfiguration configuration, Stream stream, OutputOptions outputOptions) throws IOException, NotFoundException, LicenseException, UnsupportedFeatureException, HttpException {
        if (document == null) {
            throw new IllegalArgumentException("Argument 'document' must not be null.", new NullPointerException("'document'"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 'configuration' must not be null.", new NullPointerException("'configuration'"));
        }
        if (stream == null) {
            throw new IllegalArgumentException("Argument 'stream' must not be null.", new NullPointerException("'stream'"));
        }
        long retHandle = this.addPreparedSignatureNative(this.getHandle(), Signer.getHandle(document), document, Signer.getHandle(configuration), configuration, stream, Signer.getHandle(outputOptions), outputOptions);
        if (retHandle == 0L) {
            switch (Signer.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Signer.getLastErrorMessage());
                }
                case 4: {
                    throw new IOException(Signer.getLastErrorMessage());
                }
                case 5: {
                    throw new NotFoundException(Signer.getLastErrorMessage());
                }
                case 12: {
                    throw new LicenseException(Signer.getLastErrorMessage());
                }
                case 19: {
                    throw new UnsupportedFeatureException(Signer.getLastErrorMessage());
                }
                case 24: {
                    throw new HttpException(Signer.getLastErrorMessage());
                }
            }
            Signer.throwLastRuntimeException();
        }
        return PreparedDocument.createDynamicObject(retHandle);
    }

    public Document signPreparedSignature(Document document, SignatureConfiguration configuration, Stream stream) throws IOException, LicenseException, UnsupportedFeatureException, PermissionException, HttpException, RetryException {
        if (document == null) {
            throw new IllegalArgumentException("Argument 'document' must not be null.", new NullPointerException("'document'"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 'configuration' must not be null.", new NullPointerException("'configuration'"));
        }
        if (stream == null) {
            throw new IllegalArgumentException("Argument 'stream' must not be null.", new NullPointerException("'stream'"));
        }
        long retHandle = this.signPreparedSignatureNative(this.getHandle(), Signer.getHandle(document), document, Signer.getHandle(configuration), configuration, stream);
        if (retHandle == 0L) {
            switch (Signer.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Signer.getLastErrorMessage());
                }
                case 4: {
                    throw new IOException(Signer.getLastErrorMessage());
                }
                case 12: {
                    throw new LicenseException(Signer.getLastErrorMessage());
                }
                case 19: {
                    throw new UnsupportedFeatureException(Signer.getLastErrorMessage());
                }
                case 23: {
                    throw new PermissionException(Signer.getLastErrorMessage());
                }
                case 24: {
                    throw new HttpException(Signer.getLastErrorMessage());
                }
                case 25: {
                    throw new RetryException(Signer.getLastErrorMessage());
                }
            }
            Signer.throwLastRuntimeException();
        }
        return Document.createDynamicObject(retHandle);
    }

    public Document process(Document document, Stream stream) throws IOException, LicenseException, UnsupportedFeatureException, HttpException {
        if (document == null) {
            throw new IllegalArgumentException("Argument 'document' must not be null.", new NullPointerException("'document'"));
        }
        if (stream == null) {
            throw new IllegalArgumentException("Argument 'stream' must not be null.", new NullPointerException("'stream'"));
        }
        return this.process(document, stream, null, null);
    }

    public Document process(Document document, Stream stream, OutputOptions outputOptions) throws IOException, LicenseException, UnsupportedFeatureException, HttpException {
        if (document == null) {
            throw new IllegalArgumentException("Argument 'document' must not be null.", new NullPointerException("'document'"));
        }
        if (stream == null) {
            throw new IllegalArgumentException("Argument 'stream' must not be null.", new NullPointerException("'stream'"));
        }
        return this.process(document, stream, outputOptions, null);
    }

    public Document process(Document document, Stream stream, OutputOptions outputOptions, Provider provider) throws IOException, LicenseException, UnsupportedFeatureException, HttpException {
        if (document == null) {
            throw new IllegalArgumentException("Argument 'document' must not be null.", new NullPointerException("'document'"));
        }
        if (stream == null) {
            throw new IllegalArgumentException("Argument 'stream' must not be null.", new NullPointerException("'stream'"));
        }
        long retHandle = this.processNative(this.getHandle(), Signer.getHandle(document), document, stream, Signer.getHandle(outputOptions), outputOptions, Signer.getHandle(provider), provider);
        if (retHandle == 0L) {
            switch (Signer.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 4: {
                    throw new IOException(Signer.getLastErrorMessage());
                }
                case 12: {
                    throw new LicenseException(Signer.getLastErrorMessage());
                }
                case 19: {
                    throw new UnsupportedFeatureException(Signer.getLastErrorMessage());
                }
                case 24: {
                    throw new HttpException(Signer.getLastErrorMessage());
                }
            }
            Signer.throwLastRuntimeException();
        }
        return Document.createDynamicObject(retHandle);
    }

    private native long addWarningHandlerNative(long var1, WarningNativeClass var3);

    private native boolean removeWarningHandlerNative(long var1, long var3);

    private static native long newNative();

    private native long signNative(long var1, long var3, Document var5, long var6, SignatureConfiguration var8, Stream var9, long var10, OutputOptions var12);

    private native long certifyNative(long var1, long var3, Document var5, long var6, SignatureConfiguration var8, Stream var9, long var10, MdpPermissionOptions var12, long var13, OutputOptions var15);

    private native long addTimestampNative(long var1, long var3, Document var5, long var6, TimestampConfiguration var8, Stream var9, long var10, OutputOptions var12);

    private native long addSignatureFieldNative(long var1, long var3, Document var5, long var6, SignatureFieldOptions var8, Stream var9, long var10, OutputOptions var12);

    private native long addPreparedSignatureNative(long var1, long var3, Document var5, long var6, SignatureConfiguration var8, Stream var9, long var10, OutputOptions var12);

    private native long signPreparedSignatureNative(long var1, long var3, Document var5, long var6, SignatureConfiguration var8, Stream var9);

    private native long processNative(long var1, long var3, Document var5, Stream var6, long var7, OutputOptions var9, long var10, Provider var12);

    private class WarningNativeClass {
        private WarningListener listener;
        private long context;

        public WarningNativeClass(WarningListener listener) {
            this.listener = listener;
        }

        public void warningHandler(String message, WarningCategory category, String context) {
            Warning event = new Warning(this, message, category, context);
            try {
                this.listener.warning(event);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface WarningListener
    extends EventListener {
        public void warning(Warning var1);
    }

    public class Warning
    extends EventObject {
        private static final long serialVersionUID = 726L;
        private String message;
        private WarningCategory category;
        private String context;

        private Warning(Object source, String message, WarningCategory category, String context) {
            super(source);
            this.message = message;
            this.category = category;
            this.context = context;
        }

        public String getMessage() {
            return this.message;
        }

        public WarningCategory getCategory() {
            return this.category;
        }

        public String getContext() {
            return this.context;
        }
    }
}

