/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.signaturevalidation;

import com.pdftools.internal.NativeObject;
import com.pdftools.signaturevalidation.ConstraintResult;
import com.pdftools.signaturevalidation.DataSource;
import java.time.OffsetDateTime;
import java.util.EnumSet;

public class Certificate
extends NativeObject {
    protected Certificate(long handle) {
        super(handle);
    }

    public static Certificate createDynamicObject(long handle) {
        return new Certificate(handle);
    }

    public String getSubjectName() {
        String retVal = this.getSubjectNameNative(this.getHandle());
        if (retVal == null) {
            switch (Certificate.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Certificate.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public String getSubject() {
        String retVal = this.getSubjectNative(this.getHandle());
        if (retVal == null) {
            switch (Certificate.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Certificate.throwLastRuntimeException();
        }
        return retVal;
    }

    public String getIssuerName() {
        String retVal = this.getIssuerNameNative(this.getHandle());
        if (retVal == null) {
            switch (Certificate.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Certificate.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public OffsetDateTime getNotAfter() {
        OffsetDateTime retVal = this.getNotAfterNative(this.getHandle());
        if (retVal == null) {
            switch (Certificate.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Certificate.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public OffsetDateTime getNotBefore() {
        OffsetDateTime retVal = this.getNotBeforeNative(this.getHandle());
        if (retVal == null) {
            switch (Certificate.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Certificate.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public String getFingerprint() {
        String retVal = this.getFingerprintNative(this.getHandle());
        if (retVal == null) {
            switch (Certificate.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Certificate.throwLastRuntimeException();
        }
        return retVal;
    }

    public byte[] getRawData() {
        byte[] retVal = this.getRawDataNative(this.getHandle());
        if (retVal == null) {
            switch (Certificate.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Certificate.throwLastRuntimeException();
        }
        return retVal;
    }

    public EnumSet<DataSource> getSource() {
        int retVal = this.getSourceNative(this.getHandle());
        if (retVal == 0) {
            switch (Certificate.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Certificate.throwLastRuntimeException();
                }
            }
        }
        return Certificate.getEnumSet(retVal, DataSource.class);
    }

    public ConstraintResult getValidity() {
        long retHandle = this.getValidityNative(this.getHandle());
        if (retHandle == 0L) {
            switch (Certificate.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Certificate.throwLastRuntimeException();
        }
        return ConstraintResult.createDynamicObject(retHandle);
    }

    private native String getSubjectNameNative(long var1);

    private native String getSubjectNative(long var1);

    private native String getIssuerNameNative(long var1);

    private native OffsetDateTime getNotAfterNative(long var1);

    private native OffsetDateTime getNotBeforeNative(long var1);

    private native String getFingerprintNative(long var1);

    private native byte[] getRawDataNative(long var1);

    private native int getSourceNative(long var1);

    private native long getValidityNative(long var1);
}

