/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.signaturevalidation;

import com.pdftools.crypto.HashAlgorithm;
import com.pdftools.signaturevalidation.Certificate;
import com.pdftools.signaturevalidation.CertificateChain;
import com.pdftools.signaturevalidation.SignatureContent;
import com.pdftools.signaturevalidation.TimeSource;
import com.pdftools.signaturevalidation.TimeStampContent;
import java.time.OffsetDateTime;
import java.util.EnumSet;

public class CmsSignatureContent
extends SignatureContent {
    protected CmsSignatureContent(long handle) {
        super(handle);
    }

    public static CmsSignatureContent createDynamicObject(long handle) {
        return new CmsSignatureContent(handle);
    }

    public OffsetDateTime getValidationTime() {
        OffsetDateTime retVal = this.getValidationTimeNative(this.getHandle());
        if (retVal == null) {
            switch (CmsSignatureContent.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    CmsSignatureContent.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public EnumSet<TimeSource> getValidationTimeSource() {
        int retVal = this.getValidationTimeSourceNative(this.getHandle());
        if (retVal == 0) {
            switch (CmsSignatureContent.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    CmsSignatureContent.throwLastRuntimeException();
                }
            }
        }
        return CmsSignatureContent.getEnumSet(retVal, TimeSource.class);
    }

    public HashAlgorithm getHashAlgorithm() {
        int retVal = this.getHashAlgorithmNative(this.getHandle());
        if (retVal == 0) {
            switch (CmsSignatureContent.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    CmsSignatureContent.throwLastRuntimeException();
                }
            }
        }
        return HashAlgorithm.fromValue(retVal);
    }

    public TimeStampContent getTimeStamp() {
        long retHandle = this.getTimeStampNative(this.getHandle());
        if (retHandle == 0L) {
            switch (CmsSignatureContent.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    CmsSignatureContent.throwLastRuntimeException();
                }
            }
            return null;
        }
        return TimeStampContent.createDynamicObject(retHandle);
    }

    public Certificate getSigningCertificate() {
        long retHandle = this.getSigningCertificateNative(this.getHandle());
        if (retHandle == 0L) {
            switch (CmsSignatureContent.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    CmsSignatureContent.throwLastRuntimeException();
                }
            }
            return null;
        }
        return Certificate.createDynamicObject(retHandle);
    }

    public CertificateChain getCertificateChain() {
        long retHandle = this.getCertificateChainNative(this.getHandle());
        if (retHandle == 0L) {
            switch (CmsSignatureContent.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    CmsSignatureContent.throwLastRuntimeException();
                }
            }
            return null;
        }
        return CertificateChain.createDynamicObject(retHandle);
    }

    private native OffsetDateTime getValidationTimeNative(long var1);

    private native int getValidationTimeSourceNative(long var1);

    private native int getHashAlgorithmNative(long var1);

    private native long getTimeStampNative(long var1);

    private native long getSigningCertificateNative(long var1);

    private native long getCertificateChainNative(long var1);
}

