/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.signaturevalidation;

import com.pdftools.CorruptException;
import com.pdftools.PasswordException;
import com.pdftools.internal.NativeObject;
import com.pdftools.sys.Stream;

public class CustomTrustList
extends NativeObject {
    protected CustomTrustList(long handle) {
        super(handle);
    }

    public static CustomTrustList createDynamicObject(long handle) {
        return new CustomTrustList(handle);
    }

    public CustomTrustList() {
        this(CustomTrustList.newHelper());
    }

    private static long newHelper() {
        long handle = CustomTrustList.newNative();
        if (handle == 0L) {
            switch (CustomTrustList.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            CustomTrustList.throwLastRuntimeException();
        }
        return handle;
    }

    public void addCertificates(Stream certificate) throws CorruptException {
        if (certificate == null) {
            throw new IllegalArgumentException("Argument 'certificate' must not be null.", new NullPointerException("'certificate'"));
        }
        boolean retVal = this.addCertificatesNative(this.getHandle(), certificate);
        if (!retVal) {
            switch (CustomTrustList.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 16: {
                    throw new CorruptException(CustomTrustList.getLastErrorMessage());
                }
            }
            CustomTrustList.throwLastRuntimeException();
        }
    }

    public void addArchive(Stream stream) throws CorruptException, PasswordException {
        if (stream == null) {
            throw new IllegalArgumentException("Argument 'stream' must not be null.", new NullPointerException("'stream'"));
        }
        this.addArchive(stream, null);
    }

    public void addArchive(Stream stream, String password) throws CorruptException, PasswordException {
        if (stream == null) {
            throw new IllegalArgumentException("Argument 'stream' must not be null.", new NullPointerException("'stream'"));
        }
        boolean retVal = this.addArchiveNative(this.getHandle(), stream, password);
        if (!retVal) {
            switch (CustomTrustList.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 16: {
                    throw new CorruptException(CustomTrustList.getLastErrorMessage());
                }
                case 17: {
                    throw new PasswordException(CustomTrustList.getLastErrorMessage());
                }
            }
            CustomTrustList.throwLastRuntimeException();
        }
    }

    private static native long newNative();

    private native boolean addCertificatesNative(long var1, Stream var3);

    private native boolean addArchiveNative(long var1, Stream var3, String var4);
}

