/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.signaturevalidation;

import com.pdftools.internal.NativeObject;
import com.pdftools.signaturevalidation.CmsSignatureContent;
import com.pdftools.signaturevalidation.ConstraintResult;
import com.pdftools.signaturevalidation.TimeStampContent;
import com.pdftools.signaturevalidation.UnsupportedSignatureContent;

public abstract class SignatureContent
extends NativeObject {
    protected SignatureContent(long handle) {
        super(handle);
    }

    public static SignatureContent createDynamicObject(long handle) {
        int type = SignatureContent.getType(handle);
        switch (type) {
            case 1: {
                return UnsupportedSignatureContent.createDynamicObject(handle);
            }
            case 2: {
                return CmsSignatureContent.createDynamicObject(handle);
            }
            case 3: {
                return TimeStampContent.createDynamicObject(handle);
            }
        }
        return null;
    }

    public ConstraintResult getValidity() {
        long retHandle = this.getValidityNative(this.getHandle());
        if (retHandle == 0L) {
            switch (SignatureContent.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            SignatureContent.throwLastRuntimeException();
        }
        return ConstraintResult.createDynamicObject(retHandle);
    }

    private static native int getType(long var0);

    private native long getValidityNative(long var1);
}

