/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.signaturevalidation;

import com.pdftools.crypto.HashAlgorithm;
import com.pdftools.signaturevalidation.Certificate;
import com.pdftools.signaturevalidation.CertificateChain;
import com.pdftools.signaturevalidation.SignatureContent;
import com.pdftools.signaturevalidation.TimeSource;
import java.time.OffsetDateTime;
import java.util.EnumSet;

public class TimeStampContent
extends SignatureContent {
    protected TimeStampContent(long handle) {
        super(handle);
    }

    public static TimeStampContent createDynamicObject(long handle) {
        return new TimeStampContent(handle);
    }

    public OffsetDateTime getValidationTime() {
        OffsetDateTime retVal = this.getValidationTimeNative(this.getHandle());
        if (retVal == null) {
            switch (TimeStampContent.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    TimeStampContent.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public EnumSet<TimeSource> getValidationTimeSource() {
        int retVal = this.getValidationTimeSourceNative(this.getHandle());
        if (retVal == 0) {
            switch (TimeStampContent.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    TimeStampContent.throwLastRuntimeException();
                }
            }
        }
        return TimeStampContent.getEnumSet(retVal, TimeSource.class);
    }

    public HashAlgorithm getHashAlgorithm() {
        int retVal = this.getHashAlgorithmNative(this.getHandle());
        if (retVal == 0) {
            switch (TimeStampContent.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    TimeStampContent.throwLastRuntimeException();
                }
            }
        }
        return HashAlgorithm.fromValue(retVal);
    }

    public OffsetDateTime getDate() {
        OffsetDateTime retVal = this.getDateNative(this.getHandle());
        if (retVal == null) {
            switch (TimeStampContent.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    TimeStampContent.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public Certificate getSigningCertificate() {
        long retHandle = this.getSigningCertificateNative(this.getHandle());
        if (retHandle == 0L) {
            switch (TimeStampContent.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    TimeStampContent.throwLastRuntimeException();
                }
            }
            return null;
        }
        return Certificate.createDynamicObject(retHandle);
    }

    public CertificateChain getCertificateChain() {
        long retHandle = this.getCertificateChainNative(this.getHandle());
        if (retHandle == 0L) {
            switch (TimeStampContent.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    TimeStampContent.throwLastRuntimeException();
                }
            }
            return null;
        }
        return CertificateChain.createDynamicObject(retHandle);
    }

    private native OffsetDateTime getValidationTimeNative(long var1);

    private native int getValidationTimeSourceNative(long var1);

    private native int getHashAlgorithmNative(long var1);

    private native OffsetDateTime getDateNative(long var1);

    private native long getSigningCertificateNative(long var1);

    private native long getCertificateChainNative(long var1);
}

