/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.signaturevalidation;

import com.pdftools.LicenseException;
import com.pdftools.ProcessingException;
import com.pdftools.internal.NativeObject;
import com.pdftools.pdf.Document;
import com.pdftools.pdf.SignedSignatureField;
import com.pdftools.signaturevalidation.Indication;
import com.pdftools.signaturevalidation.SignatureSelector;
import com.pdftools.signaturevalidation.SubIndication;
import com.pdftools.signaturevalidation.ValidationResults;
import com.pdftools.signaturevalidation.profiles.Profile;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Hashtable;

public class Validator
extends NativeObject {
    private Hashtable<ConstraintListener, ConstraintNativeClass> constraintDic = new Hashtable();

    protected Validator(long handle) {
        super(handle);
    }

    public static Validator createDynamicObject(long handle) {
        return new Validator(handle);
    }

    public void addConstraintListener(ConstraintListener listener) {
        if (!this.constraintDic.containsKey(listener)) {
            ConstraintNativeClass eventNativeClass = new ConstraintNativeClass(listener);
            long context = this.addConstraintHandlerNative(this.getHandle(), eventNativeClass);
            if (context == 0L) {
                Validator.throwLastRuntimeException();
            }
            eventNativeClass.context = context;
            this.constraintDic.put(listener, eventNativeClass);
        }
    }

    public void removeConstraintListener(ConstraintListener listener) {
        if (this.constraintDic.containsKey(listener)) {
            if (!this.removeConstraintHandlerNative(this.getHandle(), this.constraintDic.get(listener).context) && Validator.getLastErrorCode() != 5) {
                Validator.throwLastRuntimeException();
            }
            this.constraintDic.remove(listener);
        }
    }

    public Validator() {
        this(Validator.newHelper());
    }

    private static long newHelper() {
        long handle = Validator.newNative();
        if (handle == 0L) {
            switch (Validator.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Validator.throwLastRuntimeException();
        }
        return handle;
    }

    public ValidationResults validate(Document document, Profile profile, SignatureSelector selector) throws LicenseException, ProcessingException {
        if (document == null) {
            throw new IllegalArgumentException("Argument 'document' must not be null.", new NullPointerException("'document'"));
        }
        if (profile == null) {
            throw new IllegalArgumentException("Argument 'profile' must not be null.", new NullPointerException("'profile'"));
        }
        if (selector == null) {
            throw new IllegalArgumentException("Argument 'selector' must not be null.", new NullPointerException("'selector'"));
        }
        long retHandle = this.validateNative(this.getHandle(), Validator.getHandle(document), document, Validator.getHandle(profile), profile, selector.getValue());
        if (retHandle == 0L) {
            switch (Validator.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 12: {
                    throw new LicenseException(Validator.getLastErrorMessage());
                }
                case 21: {
                    throw new ProcessingException(Validator.getLastErrorMessage());
                }
            }
            Validator.throwLastRuntimeException();
        }
        return ValidationResults.createDynamicObject(retHandle);
    }

    private native long addConstraintHandlerNative(long var1, ConstraintNativeClass var3);

    private native boolean removeConstraintHandlerNative(long var1, long var3);

    private static native long newNative();

    private native long validateNative(long var1, long var3, Document var5, long var6, Profile var8, int var9);

    private class ConstraintNativeClass {
        private ConstraintListener listener;
        private long context;

        public ConstraintNativeClass(ConstraintListener listener) {
            this.listener = listener;
        }

        public void constraintHandler(String message, Indication indication, SubIndication subIndication, SignedSignatureField signature, String dataPart) {
            Constraint event = new Constraint(this, message, indication, subIndication, signature, dataPart);
            try {
                this.listener.constraint(event);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface ConstraintListener
    extends EventListener {
        public void constraint(Constraint var1);
    }

    public class Constraint
    extends EventObject {
        private static final long serialVersionUID = 1061L;
        private String message;
        private Indication indication;
        private SubIndication subIndication;
        private SignedSignatureField signature;
        private String dataPart;

        private Constraint(Object source, String message, Indication indication, SubIndication subIndication, SignedSignatureField signature, String dataPart) {
            super(source);
            this.message = message;
            this.indication = indication;
            this.subIndication = subIndication;
            this.signature = signature;
            this.dataPart = dataPart;
        }

        public String getMessage() {
            return this.message;
        }

        public Indication getIndication() {
            return this.indication;
        }

        public SubIndication getSubIndication() {
            return this.subIndication;
        }

        public SignedSignatureField getSignature() {
            return this.signature;
        }

        public String getDataPart() {
            return this.dataPart;
        }
    }
}

