/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.signaturevalidation.profiles;

import com.pdftools.internal.NativeObject;
import com.pdftools.signaturevalidation.CustomTrustList;
import com.pdftools.signaturevalidation.profiles.Default;
import com.pdftools.signaturevalidation.profiles.TrustConstraints;
import com.pdftools.signaturevalidation.profiles.ValidationOptions;

public abstract class Profile
extends NativeObject {
    protected Profile(long handle) {
        super(handle);
    }

    public static Profile createDynamicObject(long handle) {
        int type = Profile.getType(handle);
        switch (type) {
            case 1: {
                return Default.createDynamicObject(handle);
            }
        }
        return null;
    }

    public ValidationOptions getValidationOptions() {
        long retHandle = this.getValidationOptionsNative(this.getHandle());
        if (retHandle == 0L) {
            switch (Profile.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Profile.throwLastRuntimeException();
        }
        return ValidationOptions.createDynamicObject(retHandle);
    }

    public TrustConstraints getSigningCertTrustConstraints() {
        long retHandle = this.getSigningCertTrustConstraintsNative(this.getHandle());
        if (retHandle == 0L) {
            switch (Profile.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Profile.throwLastRuntimeException();
        }
        return TrustConstraints.createDynamicObject(retHandle);
    }

    public TrustConstraints getTimeStampTrustConstraints() {
        long retHandle = this.getTimeStampTrustConstraintsNative(this.getHandle());
        if (retHandle == 0L) {
            switch (Profile.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Profile.throwLastRuntimeException();
        }
        return TrustConstraints.createDynamicObject(retHandle);
    }

    public CustomTrustList getCustomTrustList() {
        long retHandle = this.getCustomTrustListNative(this.getHandle());
        if (retHandle == 0L) {
            switch (Profile.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Profile.throwLastRuntimeException();
                }
            }
            return null;
        }
        return CustomTrustList.createDynamicObject(retHandle);
    }

    public void setCustomTrustList(CustomTrustList value) {
        boolean retVal = this.setCustomTrustListNative(this.getHandle(), Profile.getHandle(value), value);
        if (!retVal) {
            switch (Profile.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Profile.throwLastRuntimeException();
        }
    }

    private static native int getType(long var0);

    private native long getValidationOptionsNative(long var1);

    private native long getSigningCertTrustConstraintsNative(long var1);

    private native long getTimeStampTrustConstraintsNative(long var1);

    private native long getCustomTrustListNative(long var1);

    private native boolean setCustomTrustListNative(long var1, long var3, CustomTrustList var5);
}

